﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ds/DirectoryServiceRequest.h>
#include <aws/ds/DirectoryService_EXPORTS.h>
#include <aws/ds/model/ClientAuthenticationType.h>

#include <utility>

namespace Aws {
namespace DirectoryService {
namespace Model {

/**
 */
class DisableClientAuthenticationRequest : public DirectoryServiceRequest {
 public:
  AWS_DIRECTORYSERVICE_API DisableClientAuthenticationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DisableClientAuthentication"; }

  AWS_DIRECTORYSERVICE_API Aws::String SerializePayload() const override;

  AWS_DIRECTORYSERVICE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The identifier of the directory </p>
   */
  inline const Aws::String& GetDirectoryId() const { return m_directoryId; }
  inline bool DirectoryIdHasBeenSet() const { return m_directoryIdHasBeenSet; }
  template <typename DirectoryIdT = Aws::String>
  void SetDirectoryId(DirectoryIdT&& value) {
    m_directoryIdHasBeenSet = true;
    m_directoryId = std::forward<DirectoryIdT>(value);
  }
  template <typename DirectoryIdT = Aws::String>
  DisableClientAuthenticationRequest& WithDirectoryId(DirectoryIdT&& value) {
    SetDirectoryId(std::forward<DirectoryIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of client authentication to disable. Currently the only parameter
   * <code>"SmartCard"</code> is supported.</p>
   */
  inline ClientAuthenticationType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(ClientAuthenticationType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline DisableClientAuthenticationRequest& WithType(ClientAuthenticationType value) {
    SetType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_directoryId;

  ClientAuthenticationType m_type{ClientAuthenticationType::NOT_SET};
  bool m_directoryIdHasBeenSet = false;
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace DirectoryService
}  // namespace Aws
