/*       $NetBSD: bootinfo.h,v 1.1 2002/07/20 11:52:21 mrg Exp $        */

/*-
 * Copyright (c) 2005 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _BOOTINFO_H_
#define _BOOTINFO_H_

#include <machine/param.h>
#include <sparc/bootinfo.h>

/*#define BTLOAD_MAGIC	( ('L'<<24) | ('O'<<16) | ('A'<<8) | ('D') )*/

/* Boot magic number */
#define SPARC_MACHINE_OPENFIRMWARE	0x44444230

#ifdef BOOTINFO_SIZE
#undef BOOTINFO_SIZE
#endif

#define BOOTINFO_SIZE			NBPG

#define BTINFO_DTLB_SLOTS		100
#define BTINFO_ITLB_SLOTS		101
#define BTINFO_DTLB			102
#define BTINFO_ITLB			103
#define BTINFO_KERNEND			104

#define LOOKUP_BOOTINFO(btp, info) \
do { \
	if ( ((btp) = lookup_bootinfo(info)) == NULL) { \
		panic("lookup_bootinfo: No " #info " found.\n"); \
	} \
} while (0)

struct tlb_entry {
	u_int64_t te_pa;
	u_int64_t te_va;
};

struct btinfo_count {
	struct btinfo_common common;
	int count;
};

struct btinfo_tlb {
	struct btinfo_common common;
	struct tlb_entry tlb[1];
};

struct btinfo_kernend {
	struct btinfo_common common;
	u_int64_t addr;
};

#endif /* _BOOTINFO_H_ */
