// $Id: Configuration.hh,v 1.45 2003/05/17 18:22:09 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2002 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CONFIGURATION_HH
#define CONFIGURATION_HH
#include <config.h>
#include <iostream>
#include "Naming.hh"
#include <Tag.hh>

// Be careful, glibc-2.1 defines major and minor

struct Pkg_Version
{
public:
   enum Source // precedence as follows (later values overwrite former)
   {  Not_Available, Unknown, 
   	Glademm_Compile_Time, 
   	Gtk_Config, Gtkmm_Config, Gnome_Config, Pkg_Config, MMVersion,
   	Command_Line
   };

   int mymajor;
   int myminor;
   int mymicro;
   Source source;

public:   
   Pkg_Version() : mymajor(0), myminor(0), mymicro(0), source(Not_Available) {}
   Pkg_Version(int j,int n,int c,Source s=Unknown) 
   	: mymajor(j), myminor(n), mymicro(c), source(s) 
   	{}
   bool operator==(const Pkg_Version &b) const 
   {  return mymajor==b.mymajor && myminor==b.myminor && mymicro==b.mymicro; }
   bool operator<(const Pkg_Version &b) const 
   {  if (mymajor!=b.mymajor) return mymajor<b.mymajor;
      if (myminor!=b.myminor) return myminor<b.myminor;
      return mymicro<b.mymicro;
   }
   bool operator>=(const Pkg_Version &b) const 
   {  return !(*this<b); }
   bool operator!=(const Pkg_Version &b) const 
   {  return !(*this==b); }
   Source getSource() const { return source; }
   bool operator!() const
   {  return source==Not_Available || (mymajor==0 && myminor==0 && mymicro==0); }
   
   void set_if_more_specific(const Pkg_Version &b)
   {  if (b.source >= source) 
         *this=b;
   }
};

std::ostream &operator<<(std::ostream &o, const Pkg_Version &v);
std::ostream &operator<<(std::ostream &o, const Pkg_Version::Source s);

struct Configuration : public Naming
{  std::string destination_directory;
   std::string source_directory;
   std::string main_filename;
   std::string in_filename;
   std::string pixmap_dir;
   std::string commandline;
   std::string pixmap_dir_relative_to_src;
   bool debug:1;
   bool sample_code:1;
   bool bare_bones:1;
   bool no_autoconf:1;
   bool gtk_ostream:1;
   bool lookup_table:1;
   bool gnome_support:1;
   bool gettext_support:1;
   bool use_libglade:1;
   bool has_accelerators:1;
   bool widget_names:1;
   bool optionmenu_strings:1;
   bool optionmenu_create_enum:1;
   bool do_case_conversion:1;
   bool uppercase_enums:1;
   bool mixedcase_defines:1;
   bool lookup_table_compat:1;
   bool glade2:1;
   bool embed_images:1;
   bool baseclass:1;
   bool non_virtual_callbacks:1;
   bool need_notebook_hack:1;
   bool gnome2:1;
   bool libglade_support:1;
   bool only_private_widgets:1; // this is used to print out a warning
   int verbose;
   Pkg_Version pc_version;
   Pkg_Version gtk_version;
   Pkg_Version gtkmm_version;
   Pkg_Version libgnomemm_version;
   Pkg_Version libgnomeuimm_version;
   Pkg_Version libbonobomm_version;
   Pkg_Version libbonobouimm_version;
   Pkg_Version automake_version;
   std::string automake_name;
   Pkg_Version autoconf_version;
   std::string autoconf_name;
   std::string template_postfix;
   std::string source_suffix, header_suffix;
   std::string image_provider;
   
   Tag custom_signal_args;
   
   Configuration()
   : debug(), sample_code(), bare_bones(), 
     no_autoconf(), gtk_ostream(), lookup_table(), gnome_support(),
     gettext_support(), use_libglade(), has_accelerators(), widget_names(),
     optionmenu_strings(), optionmenu_create_enum(true),
     do_case_conversion(), uppercase_enums(), mixedcase_defines(),
     lookup_table_compat(), glade2(),
     embed_images(true), baseclass(), non_virtual_callbacks(), 
     need_notebook_hack(), gnome2(), libglade_support(),
     only_private_widgets(true),
     verbose(),
     // had been "_glade"
     template_postfix("_new"),
     source_suffix(".cc"), header_suffix(".hh"),
     custom_signal_args("")
   {  if (gnome2) select_Gnome2();
      else select_Gnome1();
   }
   
   void select_Gnome1();
   void select_Gnome2();

   bool Gtkmm2() const
   {  return gtkmm_version>=Pkg_Version(1,3,0);
   }
   bool Gtkmm1() const
   {  return gtkmm_version<Pkg_Version(1,3,0);
   }
   bool Gnome2() const
   {  return libgnomemm_version>=Pkg_Version(1,3,0);
   }
   bool Gnome1() const
   {  return libgnomemm_version<Pkg_Version(1,3,0);
   }

	// this belongs to Naming, but it is Configuration dependant
	const std::string GtkmmIncludePath() const throw();
	const std::string GnomemmIncludePath() const throw();
	const std::string GnomeUImmIncludePath() const throw();
	const std::string BonobommIncludePath() const throw();
	const std::string BonoboUImmIncludePath() const throw();
};

extern struct Configuration Configuration;

// note: replace these macros soon!
#define GTKMM1 (Configuration.Gtkmm1())
#define GTKMM2 (Configuration.Gtkmm2())
#define GNOME1 (Configuration.Gnome1())
#define GNOME2 (Configuration.Gnome2())
#endif
