// $Id: glademm-embed.cc,v 1.6 2003/04/15 15:42:12 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2003  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <iostream>
#include <string>
#include <fstream>

const std::string CName(const std::string &tag) throw()
{  std::string ret("");
   std::string::const_iterator i=tag.begin();
   // first char [_a-zA-Z]
   if (i!=tag.end()) 
   {  if (!(*i=='_' || isalpha((unsigned char)*i))) ret+='_';
      else ret+=*i;
      ++i;
   }
   // now [_a-zA-Z0-9]
   for (;i!=tag.end();++i) 
   {  if (!(*i=='_' || isalnum((unsigned char)*i))) ret+='_';
      else ret+=*i;
   }
   return ret;
}


int main(int argc, char **argv)
{  std::string file;

   if (argc>1) file=argv[1];
   else
   {  std::cerr << "USAGE: " << argv[0] << " filename\n";
      return 1;
   }
   std::cout << "/* generated by glademm-embed */\n\n";
   std::cout << "/* use it like \n"
   		" *   extern const unsigned char "<<CName(file)<<"_data[];\n"
   		" *   extern const unsigned "<<CName(file)<<"_size;\n"
   		" *\n"
   		" *   Glib::RefPtr<Gdk::PixbufLoader> loader=Gdk::PixbufLoader::create();\n"
   		" *   loader->write("<<CName(file)<<"_data, "<<CName(file)<<"_size);\n"
   		" *   loader->close();\n"
   		" *   new Gtk::Image(loader->get_pixbuf());\n"
   		" */\n\n";
   std::cout << "extern const unsigned char " << CName(file) << "_data[]"
   	<< " = \n{";
   	
   size_t filesize=0;
   {  std::ifstream is((file).c_str());
      while (is.good())
      {  /* unsigned ... hmmm g++3.1 does not like this ... */ char buf[16];
         is.read(buf,sizeof buf);
         size_t read=is.gcount();
         std::cout << '\t';
         for (size_t x=0;x<read;++x) std::cout << (unsigned int)(unsigned char)buf[x] << ',';
         std::cout << '\n';
         filesize+=read;
      }
   }
   std::cout << "};\n";
   std::cout << "extern const unsigned " << CName(file) << "_size = " << filesize << ";\n";
   return 0;
}
