// $Id: pixmap.cc,v 1.28 2002/05/31 07:42:56 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "misc.hh"

class Gtk_Pixmap : public Gtk_Misc
{public:
	typedef Gtk_Misc Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Pixmap();
	
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const;
	virtual void GCInclude(const Widget &w, CxxFile &f) const;
	virtual void ApplyPreferences(Tag &t) const;
};

static Gtk_Pixmap Gtk_Pixmap;

const std::string Gtk_Pixmap::TypeName(const Widget &w) const
{  return GtkPrefix()+"Pixmap";
}

const std::string Gtk_Pixmap::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"pixmap.h";
}

Gtk_Pixmap::Gtk_Pixmap()
{  Writer["GtkPixmap"]=this;
}

void Gtk_Pixmap::ConstructionArgs(Widget const &w, CxxFile &f) const
{  f.FunctionArg();
   std::string filename=w.getProperty("filename");
   const std::string xpm_ident=xpmname(filename);
   if (Configuration.embed_images && !xpm_ident.empty())
      f << xpm_ident;
   else if (!filename.empty())
   {  if (filename[0]!='/' && filename.substr(0,2)!="./" 
         	&& !Configuration.pixmap_dir_relative_to_src.empty())
            filename=Configuration.pixmap_dir_relative_to_src+"/"+filename;
      f << Configuration.CString_WithQuotes(filename);
   }
}

void Gtk_Pixmap::GCInclude(const Widget &w, CxxFile &f) const
{  Parent::GCInclude(w,f);
   const std::string filename=w.getProperty("filename");
   const std::string xpm_ident=xpmname(filename);
   if (!xpm_ident.empty())
      f.Include(Configuration.CString(Configuration.pixmap_dir_relative_to_src+"/"+filename),true);
}

void Gtk_Pixmap::ApplyPreferences(Tag &t) const
{  if (GTKMM2)
   {  static_cast<GladeTag*>(&t)->setWidgetType("GtkImage");
      Widget w(&t);
      w.setProperty("pixbuf",w.getProperty("filename"));
      LookupWriter(w).ApplyPreferences(t);
   }
   else
      Parent::ApplyPreferences(t);
}

