// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------

#include "savant.hh"
#include "error_func.hh"
#include "IIRBase_FloatingPointLiteral.hh"
#include "IIR_FloatingPointLiteral.hh"
#include <cstring>
#include "sstream-wrap.hh"


IIRBase_FloatingPointLiteral::IIRBase_FloatingPointLiteral() 
  : base( 10 ),
    mantissa( 0 ),
    mantissa_length( 0 ),
    exponent( 0 ),
    exponent_length( 0 ){
}


IIRBase_FloatingPointLiteral::~IIRBase_FloatingPointLiteral() {}


IIR_FloatingPointLiteral*
IIRBase_FloatingPointLiteral::get(IIR_Int32 base, 
			    IIR_Char* mantissa, IIR_Int32 mantissa_length,
			    IIR_Char* exponent, IIR_Int32 exponent_length) {
  ASSERT((mantissa != NULL && mantissa_length > 0));

  IIR_FloatingPointLiteral *retval = new IIR_FloatingPointLiteral();
  retval->_set_base(base);
  retval->_set_mantissa(strdup(mantissa), mantissa_length);
  if (exponent != NULL) {
    retval->_set_exponent(strdup(exponent), exponent_length);
  } else {
    retval->_set_exponent(exponent, exponent_length);
  }

  return retval;
}


void
IIRBase_FloatingPointLiteral::release() {
  delete this;
}


const string
IIRBase_FloatingPointLiteral::print(IIR_Int32 length) {
  ostringstream os;
  os << "print(IIR_Int32) not defined for IIR node: " << get_kind_text();
  report_error(this, os.str());
  abort();

  return "";
}


void
IIRBase_FloatingPointLiteral::_set_base(IIR_Int32 b) {
  base = b;
}


IIR_Int32
IIRBase_FloatingPointLiteral::_get_base() {
  return base;
}


void
IIRBase_FloatingPointLiteral::_set_mantissa(IIR_Char* m, IIR_Int32 ml) {
  mantissa = m;
  mantissa_length = ml;
}


IIR_Char*
IIRBase_FloatingPointLiteral::_get_mantissa() {
  return mantissa;
}


IIR_Int32
IIRBase_FloatingPointLiteral::_get_mantissa_length() {
  return mantissa_length;
}


void
IIRBase_FloatingPointLiteral::_set_exponent(IIR_Char* e, IIR_Int32 el) {
  exponent = e;
  exponent_length = el;
}


IIR_Char*
IIRBase_FloatingPointLiteral::_get_exponent() {
  return exponent;
}


IIR_Int32
IIRBase_FloatingPointLiteral::_get_exponent_length() {
  return exponent_length;
}
