
#ifndef IIRSCRAM_ARCHITECTURE_DECLARATION_HH
#define IIRSCRAM_ARCHITECTURE_DECLARATION_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF4 THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Malolan Chetlur    
//          Narayanan Thondugulam
//          Krishnan Subramani

#include "IIRBase_ArchitectureDeclaration.hh"
#include "symbol_table.hh"

class IIRScram_ArchitectureDeclaration : public IIRBase_ArchitectureDeclaration {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl_binding_name(ostream &);
  void _publish_vhdl_with_library_name(ostream &);

  declaration_type _get_type();
  IIR_EntityDeclaration* _get_entity();

  IIR_ArchitectureDeclaration *_get_cc_instantiated_architecture();
  IIR_EntityDeclaration *_get_cc_instantiated_entity();

  void _publish_cc();
  void _publish_cc_elaborate();
  void _publish_cc_declarations();
  void _publish_cc_object_pointers_init( published_file &_cc_out );
  void _publish_cc_binding_name( ostream& outstream );
  void _publish_cc_signal_objects_init( published_file &_cc_out, IIR_Boolean = FALSE );
  void _publish_cc_scoping_prefix( ostream &os, IIR *, IIR * );
  void _publish_cc_implicit_signals( published_file &_cc_out, IIR_DeclarationList *);
  void _publish_cc_include( published_file &_cc_out );
  void _mangle_declarator();

  /** Publish VHDL-AMS specific header files. */
  void _publish_cc_ams_includes(published_file &);

  /** Function that calls the subclass functions to publish characteristic
      expressions. */
  void _publish_cc_ams_form_characteristic_expressions(published_file &);  
    
  /** This method gets called in the case of a selected name
      architecture.member.  The architecture doesn't need to be added, so
      this method is stubbed as an empty method here. */
  void _add_decl_into_cgen_symbol_table(){}
  
  set<IIR_Declaration> *_find_declarations( IIR_Name * );

#ifdef PROCESS_COMBINATION
  void _static_elaborate(IIR_ArchitectureDeclaration*, IIR_DeclarationList*,
			 char*);
  void _combine();
#endif

  void _make_interface_visible( symbol_table * );

  void _type_check();
  IIR_PortList *_get_port_list();
  IIR_GenericList *_get_generic_list();
  IIR_List *_get_statement_list();

  IIR_Boolean _is_iir_architecture_declaration(){ return TRUE; }
  IIR_Boolean _is_secondary_unit(){ return TRUE; }

  /** This list holds the component declarations in this architectures
      declarative region.  It will be used to post process configuration
      specficiations such that ALL and OTHERS can be resolved, and so that
      labels that are not declared until the statement part can be resolved
      as well. */
  IIR_DeclarationList *_get_component_declarations();
  void _set_component_declarations(   IIR_DeclarationList * );

  void _set_configuration_specifications( IIR_DeclarationList * );
  IIR_DeclarationList *_get_configuration_specifications();

  IIR_DeclarationList* _get_declaration_list();

  IIR* _get_enclosing_scope() { return NULL; }

  symbol_table cgen_arch_sym_tab;

protected:
  IIRScram_ArchitectureDeclaration();
  virtual ~IIRScram_ArchitectureDeclaration() = 0;
    
private:
  //@{ These functions are used for generating code that is useful for doing 
  //   dynamic elaboration
  void _publish_cc_class( published_file &_cc_out );
  void _publish_cc_headerfile();
  void _publish_cc_ccfile();
  void _publish_cc_constructor( published_file &_cc_out );
  void _publish_cc_constructor_with_no_arguments( published_file &_cc_out );
  void _publish_cc_constructor_with_arguments( published_file &_cc_out );
  void _publish_cc_instantiate( published_file &_cc_out );
  void _publish_cc_createNetInfo( published_file &_cc_out );
  void _publish_cc_connect( published_file &_cc_out );
  void _publish_cc_headerfiles_for_cc( published_file &_cc_out );
  void _publish_cc_blocks_elaborate( published_file &_cc_out );
  
  void _publish_cc_ams_objects(published_file &);
  void _publish_cc_ams_objects_init(published_file &, IIR_Boolean &);
  void _publish_cc_ams_form_global_quantity_list(published_file &);

  void _publish_cc_ams_form_break_set( published_file &_cc_out );
  void _publish_cc_ams_initialize_signals( published_file &_cc_out );
  void _publish_cc_break_signal_info( published_file &_cc_out );
  //@}
   
  IIR_Boolean _is_ams_objects_present;

  /** This method publishes the necessary foreign process pointer when
      an architecture is foreign. */
  void _publish_cc_foreign_process_pointer( published_file &_cc_out );

  /** Returns true if there is a foreign attribute associated with
     this architecture. */
  bool _is_foreign_architecture();

  /** Returns the foreign attribute associated with this architecture.
     If there is more than one, returns the last one. */
  IIR_AttributeSpecification *_get_foreign_attribute();

  /** Get the design unit name for this design unit. */
  const string _get_cc_design_unit_name();

  void _publish_cc_include_decls_prefix( ostream &os );
  
  /** Publishes the instantiate method for a foreign architecture. */
  void _publish_cc_foreign_instantiate( published_file &_cc_out );

  /** Publishes the createNetInfo method for a foreign architecture. */
  void _publish_cc_foreign_createNetInfo( published_file &_cc_out );

  /** Publishes the "allocateModule" C function needed to load this architecture
      as a module. */
  void _publish_cc_allocate_module( published_file &_cc_out );

  /** Publishes the connect terminals. Connect terminals describes terminal
      association. */
  void _publish_cc_ams_connect_terminals(published_file &);

#ifdef PROCESS_GRAPH
  void _publish_cc_driver_info( published_file &_cc_out );
#endif

};
#endif
