
#ifndef IIRSCRAM_ASSOCIATION_LIST_HH
#define IIRSCRAM_ASSOCIATION_LIST_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Narayanan Thondugulam

#include "IIRBase_AssociationList.hh"
template <class type> class set;
class IIR_InterfaceList;
class IIR_IndexedName;
class IIR_Name;
class IIR_InterfaceDeclaration;
class IIR_DesignatorList;
class IIR_ComponentInstantiationStatement;
class IIR_AboveAttribute;

class IIRScram_AssociationList : public IIRBase_AssociationList {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void append( IIR_AssociationElement * );
  void prepend( IIR_AssociationElement * );
  IIR_AssociationElement *first();
  IIR_AssociationElement *successor( IIR_AssociationElement * );
  IIR_AssociationElement *get_nth_element( int );
  void _replace( IIR_AssociationElement *to_replace, IIR_AssociationElement *replace_with );

  IIR_Boolean _is_resolved();

  void _publish_vhdl(ostream &);
  void _publish_vhdl_without_formals(ostream &);
  
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_bounds( published_file &_cc_out );
  void _publish_cc_state_object_init( published_file &_cc_out );
  void _publish_cc_subprogram_arguments( published_file &_cc_out );
  void _publish_cc_for_index( published_file &_cc_out );
  void _publish_cc_generic_map_aspect( published_file &_cc_out );
  void _publish_cc_generic_map_aspect_for_conc_stmts( published_file &_cc_out );
  void _publish_cc_port_map_associations( published_file &_cc_out );
  int  _publish_cc_unconstrained_ports( published_file &_cc_out, IIR_Boolean commaFlag );
  void _publish_cc_elaborate( published_file &_cc_out );

  void _publish_cc_necessary_temporaries_for_TC( published_file &_cc_out, 
						 IIR_InterfaceList *formals_list);
  void _publish_cc_with_temporaries_for_TC( published_file &_cc_out, 
					    IIR_InterfaceList *formals_list);
  void _publish_cc_restore_from_temporaries( published_file &_cc_out, 
					     IIR_InterfaceList *);

  void _publish_cc_array_index( published_file &_cc_out );


  void _set_passed_through_out_port(IIR_Boolean); // Parameter ignored!!
  
  void _get_list_of_input_signals( set<IIR> *list );
  void _get_signal_source_info( set<IIR> *siginfo );
  void _build_sensitivity_list( IIR_DesignatorList* sensitivity_list );
  void _build_above_attribute_set( set<IIR_AboveAttribute> * );
  void _add_decl_into_cgen_symbol_table();
  IIR_Int32 _get_number_of_element_associations();

  ostream &_print( ostream & );  
  void _resolve_and_order( IIR_InterfaceList *formal_list,
			   IIR_InterfaceList *local_list,
			   IIR *line_info );

  IIR_Boolean _check_valid_arguments( IIR_InterfaceList *formal_list,
				      IIR_InterfaceList *local_list );

  /** This method takes an interface list, and fills in all of the default
      values for associations that weren't specified.  It will generate
      error messages when errors occur. */
  void _fill_in_defaults( IIR *line_info, IIR_InterfaceList *formal_list );

  /**
     Used by
     IIRScram_ComponentInstantiationStatement#_build_default_entity_aspect
     to build the default maps, as per the rules on pg 80 of the '93 LRM.
  */
  void _build_default_map( IIR_ComponentInstantiationStatement *err_info,
			   IIR_InterfaceList *formal_list,
			   IIR_InterfaceList *actual_list );
			   

  /** IIR_AssociationLists are used for aggregates (both array and record)
      and for paramter lists for functions, among other things.  Each of
      these uses has its own notion of globally static, so we must call the
      right function depending on the context.
  */
  IIR_Boolean  _is_globally_static_for_array();
  IIR_Boolean  _is_globally_static_for_record();
  IIR_Boolean  _is_globally_static_for_function();
  IIR_Boolean  _is_static_expression();
  IIR_Boolean  _are_all_scalars();
  IIR_Boolean _is_above_attribute_found();
  
  IIR *_clone();
  
protected:
  IIRScram_AssociationList() {}
  virtual ~IIRScram_AssociationList() = 0;
    
private:
  /** This method is responsible for checking to see if this list matches the
      interface list passed in, OR, for resolving a mathing list.  If this
      method is called with an incorrect interface list and the boolean argument
      is TRUE, it should abort. */
  IIR_Boolean _check_or_resolve( IIR_InterfaceList *formal_list,
				 IIR_InterfaceList *local_list,
				 IIR_Boolean resolve = TRUE );  
  
  /** This method checks the positional part of an argument list.  It only
      blows up on errors if the second parameter is TRUE.  It returns -1 if
      an argument didn't match. */
  IIR_Int32 _process_positional_part( IIR_InterfaceList *, IIR_Boolean resolve = TRUE );

  IIR_InterfaceDeclaration *_find_declaration_in_formal( IIR_AssociationElement * );
  IIR_Declaration *_find_declaration( IIR_Name *to_find, IIR_DeclarationList *list );
  IIR *_find_formal_designator( IIR *formal_part );
  IIR_Declaration *_find_formal_declaration( IIR *formal_designator,
					     IIR_InterfaceList *formal_list  );
  IIR *_find_actual_designator( IIR *actual_part );

  bool _find_formal_types( IIR_AssociationElement *current_association,		  
			   IIR *actual_part, 
			   IIR *actual_designator,
			   IIR *formal_part,
			   IIR *formal_designator,
			   IIR_Declaration *formal_declaration,
			   set<IIR_TypeDefinition> *add_types_to_me );

  IIR_Name *_get_formal_designator_from_indexed_name( IIR_IndexedName * );
  IIR *_get_actual_designator_from_indexed_name( IIR_IndexedName * );

};
#endif
