
#ifndef IIRSCRAM_BRANCH_QUANTITY_DECLARATION_HH
#define IIRSCRAM_BRANCH_QUANTITY_DECLARATION_HH

// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.
 
// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.
 
// Authors: Harish Venkataramani venkath@ececs.uc.edu

#include "IIRBase_BranchQuantityDeclaration.hh"
#include "IIR_IndexedName.hh"
#include <vector>

using std::vector;

class IIRScram_BranchQuantityDeclaration : public IIRBase_BranchQuantityDeclaration {
	
public:
  void _publish_vhdl_decl(ostream &);
  void _publish_cc_lvalue(published_file &);
  IIR_Int32 get_plus_terminal_id();
  IIR_Int32 get_minus_terminal_id();
  IIR_Int32 get_num_across_elements();
  IIR_Int32 get_num_through_elements();
  void _set_stmt_node_index(IIR_Int32 *, bool, bool&);
  void _set_stmt_qty_index(IIR_Int32 *, set<IIR_Declaration> *);
  IIR_Int32 _get_stmt_qty_index();
  void _flush_stmt_index();
  void _type_check();
  void _publish_cc_ams_function(published_file &);
  void _publish_cc_decl(published_file &);
  void _publish_cc_tolerances( published_file &); 
  IIR_Boolean _is_across_quantity();
  IIR_Boolean _is_branchQ() {return TRUE;}
  IIR_Boolean _is_readable();

protected:
  IIRScram_BranchQuantityDeclaration();
  virtual ~IIRScram_BranchQuantityDeclaration() = 0;
  double RTOL;
  double ATOL;

private:
  void _publish_cc_init_quantity(ostream &);
  IIR_Int32 _stmt_qty_index;
  vector <IIR_Int32> _stmt_node_index;
  IIR_Int32 _qty_occurence_index;
  double default_rtol;
  double default_atol;
};
#endif


