
#ifndef IIRSCRAM_CONCURRENT_GENERATE_IF_STATEMENT_HH
#define IIRSCRAM_CONCURRENT_GENERATE_IF_STATEMENT_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam

//---------------------------------------------------------------------------

#include "IIRBase_ConcurrentGenerateIfStatement.hh"

class IIR_List;

class IIRScram_ConcurrentGenerateIfStatement : public IIRBase_ConcurrentGenerateIfStatement {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);

  void _type_check();

  IIR_List *_get_statement_list(){ return &concurrent_statement_part; }

  void _publish_cc_generate_elaborate( published_file &_cc_out );
  void _publish_cc( published_file &_cc_out );
  void _publish_cc_declarations();
  void _publish_cc_class( published_file &_cc_out );
  void _publish_cc_headerfile();
  void _publish_cc_elaborate( published_file &_cc_out );
  void _publish_cc_ccfile();
  void _publish_cc_headerfiles_for_cc( published_file &_cc_out );
  void _publish_cc_constructor( published_file &_cc_out );
  void _publish_cc_constructor_with_no_arguments( published_file &_cc_out );
  void _publish_cc_signal_objects_init( published_file &_cc_out, IIR_Boolean = FALSE );
  void _publish_cc_object_pointers_init( published_file &_cc_out );
  void _publish_cc_generate_condition( published_file &_cc_out );
  void _publish_cc_instantiate( published_file &_cc_out );
  void _publish_cc_createNetInfo( published_file &_cc_out );
  void _publish_cc_connect( published_file &_cc_out );
  void _publish_cc_connect_call( published_file &_cc_out ){ _publish_cc_connect_call_generate( _cc_out ); }
  void _publish_cc_getGenerateConstant( published_file &_cc_out );
  void _publish_cc_resetGenerateConstant( published_file &_cc_out );
  void _publish_cc_body_for_component_createNetInfo( published_file &_cc_out, IIR_ArchitectureStatement*);
  void _publish_cc_static_members( published_file &_cc_out );
  void _publish_cc_init( published_file &_cc_out );
  virtual IIR_AssociationList *_get_generic_map_aspect(){ return NULL; }

  IIR_DeclarationList* _get_declaration_list();
  
  IIR_Boolean _is_concurrent_generate_statement() { return TRUE; };

  IIR_Label *_find_instantiate_label( IIR_SimpleName * );

protected:
  IIRScram_ConcurrentGenerateIfStatement() {};
  virtual ~IIRScram_ConcurrentGenerateIfStatement() = 0;
    
private:
};
#endif
