#ifndef IIRSCRAM_DESIGNATORBYALL_HH
#define IIRSCRAM_DESIGNATORBYALL_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_DesignatorByAll.hh"
#include "savant.hh"
#include <cstring>

class IIRScram_DesignatorByAll : public IIRBase_DesignatorByAll {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_vhdl_decl(ostream &);

  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_designator( published_file &_cc_out );

  ostream &_print( ostream &os );
  const string _convert_to_library_name(){ return ""; }
  
  set<IIR_Declaration> *_symbol_lookup( set<IIR_Declaration> * );

  set<IIR_TypeDefinition> *_get_rval_set( set<IIR_Declaration> *, 
					  IIR_Boolean (IIR::*constraint_function)() = 0 );

  set<IIR_TypeDefinition> *_get_rval_set( set<IIR_TypeDefinition> *, 
					  IIR_Boolean (IIR::*constraint_function)() = 0 );


  IIR_Declaration *_determine_decl_in_set( set<IIR_Declaration> *, IIR_TypeDefinition * );
  IIR_TypeDefinition *_determine_rval_in_set( set<IIR_TypeDefinition> *prefix_types,
					      IIR_TypeDefinition *return_type );

  IIR *_rval_to_decl( IIR_TypeDefinition *prefix_type, IIR_TypeDefinition *suffix_rval );
  IIR *_rval_to_decl( IIR_Declaration *prefix_decl, IIR_TypeDefinition *suffix_rval );

  IIR_Boolean _is_resolved();
  IIR_Boolean _is_writable(){ return TRUE; };
  IIR_Boolean _is_readable(){ return TRUE; };
  IIR_Boolean _is_by_all(){ return TRUE; }

protected:
  IIRScram_DesignatorByAll() {}
  virtual ~IIRScram_DesignatorByAll() = 0;
    
private:
};
#endif
