
#ifndef IIRSCRAM_LTF_ATTRIBUTE_HH
#define IIRSCRAM_LTF_ATTRIBUTE_HH

// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Prashanth Cherukuri cherukps@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_LTFAttribute.hh"
class IIR_Declaration;
template <class type> class dl_list;
class IIR_LTFAttribute;

/** This class describes the 'ltf attribute.  For a scalar quantity Q, the
    attribute Q'ltf(num, den) yields a quantity whose type is the base type
    of Q and value is the Laplace transform of Q.num and den are the
    numerator and denominator polynomials, specified as real_vector
    arrays. */
class IIRScram_LTFAttribute : public IIRBase_LTFAttribute {

public:
  /** @name Method for publishing VHDL code. */
  void _publish_vhdl(ostream&);
	
  /** @name C++ publishing methods.
    
      These methods relate to the publishing of C++.
  */
  void _publish_cc_lvalue( published_file &);
  void _publish_cc_decl(published_file &);

  /** Sets an index to each quantity in the equation. */
  void _set_stmt_qty_index(IIR_Int32 *index, set<IIR_Declaration> *quantity_set);
  /** Returns the stored index value. */
  IIR_Int32 _get_stmt_qty_index();
  /** Uses the index assigned to each quantity and publishes the quantities present in the simultaneous statement. */ 
  void _publish_cc_ams_function(published_file &);

  /** Resets index assigned to each quantity in the Simultaneous Equation. */
  void _flush_stmt_index();

  /** This returns an IIR_TextLiteral when the LTF attribute is  instantiated. */
  IIR_TextLiteral * _build_attribute_name();
  /** This returns the subtype of the quantity to which the attribute is attached. */
  IIR_TypeDefinition * get_subtype();
  /** Returns a pointer to the Quantity created by the build free quantity declaration. */  
  IIR_Declaration * _get_implicit_declaration( const string & , IIR_TypeDefinition *  );

  /** Function for processing the numerator and denominator parts of the attributes's suffix. */
  void _resolve_attribute_parameters();

protected:
  IIRScram_LTFAttribute() {} ;
  virtual ~IIRScram_LTFAttribute() = 0;

private:
  
};
#endif
