
#ifndef IIRSCRAM_SIGNAL_ASSIGNMENT_STATEMENT_HH
#define IIRSCRAM_SIGNAL_ASSIGNMENT_STATEMENT_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam

class IIR_DesignatorList;
class IIR_List;
class IIR_AboveAttribute;
template <class type> class set;

#include "IIRBase_SignalAssignmentStatement.hh"

class IIRScram_SignalAssignmentStatement : public IIRBase_SignalAssignmentStatement {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_cc( published_file &_cc_out );

  void _build_wait_list(dl_list<IIRScram_WaitStatement>* ) {}
  void _get_list_of_input_signals( set<IIR> *list );
  IIR_Boolean _is_sequential_signal_assignment(){ return TRUE; }
  void _get_signal_source_info( set<IIR> *siginfo );

  IIR *_clone();

  void _type_check();

  IIR *_get_target();
  void _set_target( IIR * );

  IIR_DelayMechanism _get_delay_mechanism();
  void _set_delay_mechanism( IIR_DelayMechanism );

  IIR *_get_reject_time_expression();
  void _set_reject_time_expression( IIR * );

  IIR_Boolean _is_resolved();

  IIR_Boolean _is_above_attribute_found();
  void _build_above_attribute_set(set<IIR_AboveAttribute> *);

protected:
  IIRScram_SignalAssignmentStatement() {}
  virtual ~IIRScram_SignalAssignmentStatement() = 0;
    
private:
  /** Publishes the target expression for the signal assignemt statement. */
  void _publish_cc_target( published_file &_cc_out );

  /** Publishes the time expression that the TyVis wants to see. */
  void _publish_cc_time_expression( published_file &_cc_out, 
				    IIR_Boolean first );
};
#endif
