
#ifndef IIRSCRAM_SIMPLE_SIMULTANEOUS_STATEMENT_HH
#define IIRSCRAM_SIMPLE_SIMULTANEOUS_STATEMENT_HH

// Copyright (c) 2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Sivakumar Gowrisankar             gowriss@ececs.uc.edu
//          Kathiresan Nellayappan
//          Vasudevan Shanmugasundaram
//          Venkateswaran Krishna

#include "IIRBase_SimpleSimultaneousStatement.hh"
#include "symbol_table.hh"

class IIRScram_SimpleSimultaneousStatement : public IIRBase_SimpleSimultaneousStatement {
  
public:
  void _publish_vhdl(ostream &);
  void _publish_cc(published_file &);
  
  /** Publish the prototype for the simultaneous equation */
  void _publish_cc_ams_function_prototype(published_file &);

  /** Publish the body of the simultaneous equation */
  void _publish_cc_ams_function_body(published_file &);

  /** Publish the constructors for the simultaneous equations */
  void _publish_cc_characteristic_expressions(IIRScram_ArchitectureStatement::SimultaneousIfPublishingPart,
                                              published_file & );
  
  /** Publish the implicit reference quantities created for
      T'reference, where T is a terminal */
  void _publish_cc_implicit_reference_equations(published_file &_cc_out);  
  
  /** Publish the implicit contribution quantities created for
      T'contribution, where T is a terminal */
  void _publish_cc_implicit_contribution_equations(published_file &_cc_out);
  
  /** Publish the implicit differential quantities created for
      Q'dot, where Q is a quantity*/
  void _publish_cc_implicit_differential_equations(published_file &_cc_out);

  symbol_table cgen_sym_tab;
  set<IIR_Declaration> _unique_qtys;
  set<IIR_Declaration> _unique_signals; 
  set<IIR_Declaration> _unique_generic_constants;
 
  IIR_Int32 _stmt_qty_index;
  IIR_Int32 _stmt_signal_index;
  IIR_Int32 _stmt_node_index;

  IIR_Boolean _is_simultaneous_statement();
  IIR_Boolean _is_free_quantity_present();
     
  /** Converts the left and right expressions into its rval, stores them
      and does a type check between left-side and right-side
      expressions.  */
  void _type_check();
  
protected:
  IIRScram_SimpleSimultaneousStatement();
  virtual ~IIRScram_SimpleSimultaneousStatement() = 0;

private:
  IIR_Label * _mangled_stmt_label;
  IIR_Boolean _free_quantity_present;
  void _publish_cc_ams_equation_constructor( SimultaneousIfPublishingPart, 
                                             published_file & );
};
#endif
