#ifndef IIRSCRAM_SUBPROGRAM_DECLARATION_HH
#define IIRSCRAM_SUBPROGRAM_DECLARATION_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_SubprogramDeclaration.hh"
class IIRScram_TypeDefinition;
class IIRScram_DeclarationList ;
class IIR_SubprogramDeclaration;
class IIR_List;

class IIRScram_SubprogramDeclaration : public IIRBase_SubprogramDeclaration {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  /** This method returns the minimum number of arguments required by this
      subprogram... */
  IIR_Int32 _num_subprogram_args();
  IIR_Int32 _num_required_args();
  IIR_Boolean _found_return_statement( );

  /** See header of IIR_Declaration for description. */
  bool _check_param( IIR_TypeDefinition *type_def, int arg_num );

  /** This method type checks all of the return statements in this
      subprogram.  It recursively descends the statements within the
      declaration as well.  The return value tells us if at least one
      return was encountered. */
  IIR_Boolean _type_check_return_statements( IIR_TypeDefinition *context_set );
  
  virtual void _type_check();

  /** This method adds the declaration to the symbol table, _after_ the
      declarator and interface have been parsed, and _after_ the
      "_contains_body" flag has been set, if needed.  This is necessary
      because the symbol table needs to know the full signature to
      determine the hiding and that kind of stuff. */
  void _add_declaration();

  ostream &_print( ostream & );

  /** This method returns the type definition of the parameter passed in.
      For the first parameter, pass in 0.  If the number passed in is
      greater than the number of parameters, a NULL is returned. */
  IIR_TypeDefinition *_get_type_of_param(int);
    
  /** get the "#include"s that this subprogram needs */
  void _publish_cc_include( published_file &_cc_out );

  /** Publish the prototype required for the package class declaration. */
  void _publish_cc_prototype( published_file &_cc_out );

  /** Publish the declarative part of this subprogram */
  void _publish_cc_declarations( published_file &_cc_out );

  /** Subprograms need to access the state of the processes. For convinience
      we redfine them */
  void _publish_cc_define_current_state( published_file &_cc_out );
  
  IIR_Boolean _is_overloadable(){ return TRUE; }
  IIR_Boolean _is_subprogram(){ return TRUE; }
  IIR_Boolean _is_iir_subprogram_declaration(){ return TRUE; }

  /** Checks for the conditions under which this function may be used as a
      resolution function.  If so, extra code has to be published. */
  virtual IIR_Boolean _is_possible_resolution_function() { return FALSE; }

  /** Checks for the conditions under which this function may be used as a
      type conversion function.  If so, extra code has to be published. */
  virtual IIR_Boolean _is_possible_type_conversion_function() {return FALSE;}

  virtual void _publish_cc_resolution_function_name( published_file &_cc_out );
  virtual void _publish_cc_type_conversion_function_name( published_file &_cc_out );

  /** This method publishes default file_close for files in this
      subprogram */
  virtual void _publish_cc_implicit_file_close( published_file &_cc_out );

  /**
     We override this method.  If this is a user-defined method, we simply
     emit our mangled name.  If we're an implicit declaration, we might
     need to do more.
  */
  void _publish_cc_subprogram_call_name( published_file &_cc_out );

  /** Returns the return type of the subprogram if it is a function, else,
      returns NULL. */
  virtual IIR_TypeDefinition* _get_return_type();
  
  /** This method takes two subprogram declarations and compares their
      return values and signatures (ONLY - not parameter names or anything
      like that), and returns a boolean value indicating whether or not
      they are equivalent. */
  static IIR_Boolean _compare_signatures( IIR_SubprogramDeclaration *,
					  IIR_SubprogramDeclaration * );
  
  IIR_Boolean _is_homograph_of( IIR_Declaration * );
  IIR_Boolean _can_be_in_same_region( IIR_Declaration * );

  IIR_Boolean _is_operator();
  IIR_Boolean _is_implicit_operator();

  /** This method returns true if this method contained a body when it was parsed.
      We need this to differentiate between:
      procedure foo;
      and
      procedure foo is begin end foo;
      (Both are legal, and both could appear in a package body or entity's declarative
      region)
  */
  IIR_Boolean _contains_body();
  void _set_contains_body( IIR_Boolean );

  void _make_interface_visible( symbol_table * );

  IIR_AttributeSpecificationList* _get_attribute_specification_list() {return &attributes;}

  void _add_decl_into_cgen_symbol_table() {}
  
protected:
  IIRScram_SubprogramDeclaration();
  virtual ~IIRScram_SubprogramDeclaration() = 0;
    
private:
  /**
     Does this subprogram represent an implict file operation, like
     file_open, file_close, etc?
  */
  IIR_Boolean _is_implicit_file_operation();
  /**
     Handles the publishing of implicit file operations.
  */
  void _publish_cc_implicit_file_operation_call_name( published_file &_cc_out );

  IIR_Boolean _my_contains_body;
};
#endif

