/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "main.h"
#include "environment.h"
#include "floattext.h"

FLOATTEXT::FLOATTEXT (GLOBALDATA *global, ENVIRONMENT *env, const char *text, int xpos, int ypos, int color, alignType alignment)
{
	initialise ();
	setEnvironment (env);
	x = (double)xpos;
	y = (double)ypos;
	_current.x = (int)x;
	_current.y = (int)y;
	_current.w = 0;
	_current.h = 0;
	set_pos (xpos, ypos);
	set_text (text);
	set_color (color);
	_align = alignment;
	_global = global;
}

FLOATTEXT::~FLOATTEXT ()
{
	_env->removeObject (this);
}

void FLOATTEXT::initialise ()
{
	VIRTUAL_OBJECT::initialise ();
}

int FLOATTEXT::applyPhysics ()
{
	VIRTUAL_OBJECT::applyPhysics ();

	set_pos ((int)x, (int)y);

	age++;
	if ((maxAge != -1) && (age > maxAge))
		destroy = TRUE;

	return (0);
}

void FLOATTEXT::draw (BITMAP *dest)
{
	if (_current.w)
	{
		if (_align == LEFT) {
			textout (dest, font, _text,
				_current.x, _current.y, _color);
		} else if (_align == RIGHT) {
			textout (dest, font, _text,
				_current.x - _current.w,
				_current.y - _current.h, _color);
		} else {
			textout_centre (dest, font, _text,
				_current.x, _current.y, _color);
		}
	}
}

void FLOATTEXT::set_text (const char *text)
{
	strncpy (_text, text, 80);
	if (strlen (text) > 0) {
		_current.w = text_length (font, _text) + 2;
		_text[79] = 0;
	} else
		_current.w = 0;
	_current.h = text_height (font) + 4;
}

void FLOATTEXT::set_color (int color)
{
	_color = color;
}

void FLOATTEXT::set_pos (int x, int y)
{
	_current.x = x;
	_current.y = y;
}

int FLOATTEXT::isSubClass (int classNum)
{
	if (classNum != FLOATTEXT_CLASS)
		return (FALSE);
		//return (VIRTUAL_OBJECT::isSubClass (classNum));
	else
		return (TRUE);
}
