from ConfigWidget import ConfigWidget

import gtk

class ConfigFloat(ConfigWidget):

    def __init__(self, attrs, getter, setter, int_only = False):

        self.__int_only = int_only

        ConfigWidget.__init__(self, attrs, getter, setter)
        label = attrs.get("label", "")
        low = float(attrs.get("min", 0.0))
        high = float(attrs.get("max", 9999.0))
        digits = int(attrs.get("digits", 2))

        lbl = gtk.Label(label)
        lbl.show()
        entry = gtk.Entry()
        entry.show()
        align = gtk.Alignment(0.0, 0.0, 0.0, 0.0)
        align.show()
        align.add(lbl)

        adjustment = gtk.Adjustment(0, low, high, 1, 1, 0)
        if (self.__int_only):
            spin_button = gtk.SpinButton(adjustment, 1, 0)
        else:
            spin_button = gtk.SpinButton(adjustment, 1, digits)
        spin_button.set_numeric(True)
        spin_button.show()

        value = self._get_config()
        #self.__tooltips.set_tip(spin_button, help)

        spin_button.set_value(value)
        spin_button.connect("value-changed", self.__on_change)

        self.__widgets = (align, spin_button)


    def get_widgets(self): return self.__widgets


    def __on_change(self, src):

        if (self.__int_only):
            value = src.get_value_as_int()
        else:
            value = src.get_value()
            
        self._set_config(value)
