from utils.Observable import Observable


#
# Container for displays. This class is a container proxy which has to be
# replaced by an implementation derived from this.
#
class DisplayContainer(Observable):

    # observer commands
    OBS_CLOSE = 0
    OBS_GEOMETRY = 1
    OBS_LOCK = 2
    OBS_UNLOCK = 3


    def __init__(self): pass

    def is_placed(self): return 1
    def set_position(self, x, y): pass
    def set_size(self, width, height): pass
    def get_geometry(self): return (0, 0, 0, 0)

    def set_shape(self, mask): pass
    def set_window_flags(self, flags): pass
    def set_title(self, value): pass
    def set_icon(self, value): pass

    def close(self): raise NotImplementedError
