from ContainerTarget import ContainerTarget
from utils.TilingImage import TilingImage
from utils.datatypes import *
from utils import Unit

import os
import gtk


#
# Class for putting frames around targets.
#
class TargetFrame(ContainerTarget):

    def __init__(self, parent):

        self.__size = (0, 0)
        self.__inner_size = (0, 0)
        self.__frame_widths = [2, 2, 2, 2]
        self.__images = []


        ContainerTarget.__init__(self, parent)
        self.__table = gtk.Table(3, 3)
        self.__table.show()

        for x, y in [(0, 1), (1, 0), (2, 1), (1, 2),
                     (0, 0), (2, 0), (2, 2), (0, 2)]:
            img = TilingImage()
            img.set_from_color("black")
            img.show()
            self.__table.attach(img, x, x + 1, y, y + 1)
            self.__images.append(img)
        #end for

        self.__box = gtk.HBox()
        self.__box.show()
        self.__table.attach(self.__box, 1, 2, 1, 2)

        self.__table.connect("expose-event", self.__redraw_frame)
        self.add_observer(self.__on_resize)
        self._register_property("border-uris", TYPE_LIST,
                                self._setp_border_uris, self._getp)
        self._register_property("border-width", TYPE_UNIT_LIST,
                                self._setp_border_width, self._getp)
        self._register_property("color", TYPE_STRING,
                                self._setp_border_color, self._getp)

        self._setp("border-width", ["2", "2", "2", "2"])
        self._setp("color", "black")


    def get_widget(self): return self.__table


    def new_child(self, childtype, settings, children):

        child = ContainerTarget.new_child(self, childtype, settings, children)
        self.__box.add(child.get_widget())
        #self._get_child().add_observer(self.__on_resize)
        #self._init_children()
        self.__redraw_frame()



    def __on_resize(self, src, cmd):

        if (cmd == src.OBS_GEOMETRY):
            self.__redraw_frame()



    def __redraw_frame(self, src = None, event = None):

        x, y, w, h = self.get_geometry()
        x = x.as_px()
        y = y.as_px()
        w = w.as_px()
        h = h.as_px()
        if ((w, h) != self.__size):
            self.__size = (w, h)

            sizes = self.__compute_size()
            cnt = 0
            for img in self.__images:
                iw, ih = sizes[cnt]
                img.tile(max(iw, 1), max(1, ih))
                cnt += 1
            #end for
            w, h = sizes[-1]
            self.__box.set_size_request(w, h)



    def __compute_size(self):

        x, y, w, h = self.get_container_geometry()
        x = x.as_px()
        y = y.as_px()
        w = w.as_px()
        h = h.as_px()
        w1, h1, w2, h2 = self.__frame_widths
        ret = [(w1, h),
               (w, h1),
               (w2, h),
               (w, h2),
               (w1, h1),
               (w2, h1),
               (w2, h2),
               (w1, h2),
               (w, h)]

        return ret



    def __set_border_width(self, args):

        for i in xrange(len(args)):
            self.__frame_widths[i] = args[i].as_px()

        self.__size = (0, 0)
        self.adjust_geometry()



    def __set_border(self, args):

        sizes = self.__compute_size()
        cnt = 0
        for uri in args:
            w, h = sizes[cnt]
            uri = self._get_display().get_full_path(uri)
            self.__images[cnt].set_from_file(uri)
            cnt += 1
        #end for
        self.__size = (0, 0)
        self.__redraw_frame()



    def __set_border_color(self, color):

        sizes = self.__compute_size()
        for cnt in range(8):
            w, h = sizes[cnt]
            self.__images[cnt].set_from_color(color)
        #end for
        self.__size = (0, 0)
        self.__redraw_frame()



    def get_border_size(self):

        w1, h1, w2, h2 = self.__frame_widths
        return (Unit.Unit(w1, Unit.UNIT_PX), Unit.Unit(h1, Unit.UNIT_PX),
                Unit.Unit(w2, Unit.UNIT_PX), Unit.Unit(h2, Unit.UNIT_PX))

        #return self.__frame_widths[:]



    def get_container_geometry(self):

        w1, h1, w2, h2 = self.__frame_widths
        x, y, w, h = self.get_geometry()
        x = x.as_px()
        y = y.as_px()
        w = w.as_px()
        h = h.as_px()
        x += w1
        y += h1
        w -= w1 + w2
        h -= h1 + h2

        return (Unit.Unit(x, Unit.UNIT_PX), Unit.Unit(y, Unit.UNIT_PX),
                Unit.Unit(max(w, 1), Unit.UNIT_PX), Unit.Unit(max(h, 1), Unit.UNIT_PX))



    #
    # Returns the target at the given position and its path.
    #
    def get_target_at(self, px, py, path):

        x, y, w, h = self.get_geometry()

        if (x <= px <= x + w and y <= py <= y + h):
            child = self._get_child()
            if (not child): return ([], [])
            ctargets = child.get_target_at(px - x , py - y, path)

            ret = [(self, path)] + ctargets
            return ret

        else:
            return []

        #end if



    def _setp_border_uris(self, key, value):

        self.__set_border(value)
        self._setp(key, value)


    def _setp_border_color(self, key, value):

        self.__set_border_color(value)
        self._setp(key, value)


    def _setp_border_width(self, key, value):

        self.__set_border_width(value)
        self._setp(key, value)
