/*
 *  - Sprite list menu tab
 */


#include <stdio.h>
#include "../ithelib.h"
#include "../gui/igui.hpp"
#include "../console.h"
#include "../core.hpp"
#include "../gamedata.h"
#include "../init.h"
#include "../gui/menusys.h"

// defines

#define VIEWX 320
#define VIEWY 176
#define STR_LEN 32

// variables

extern int focus,SP_Id,spr_total;
extern char **sprites;

static int curspr=0;
static int SprName_Id,SprPath_Id;
static char str32[STR_LEN+1];

// functions

extern void Toolbar();
static void Nothing();

void GetSprName();
void GetSprPath();
void SprUpdate();                       // Update the displays
void NewSprite();
void PickSprite();
void DelSprite();
static int CMP(char *a, char *b);
static int SpriteInUse(int spr);

static int GetNumForFilename(char *str);

// GoFocal - The menu tab function.  This is called from the toolbar

void SP_GoFocal()
{
if(focus==1)            // Make sure we don't redraw if the user clicks again
	return;

memset(str32,' ',STR_LEN); str32[STR_LEN]=0;  // Make a 255 character string

focus=1;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(SP_Id);     // And make the button stick inwards

// Sprite list editor.
// In the top-left corner is the sprite ID number and two movement buttons.

/*
IG_TextButton(32,64,__left,SP_Prev,NULL,NULL);
SprNo_Id = IG_InputButton(64,64,"0     ",GetSprNo,NULL,NULL);
IG_TextButton(128,64,__right,SP_Next,NULL,NULL);
*/

IG_TextButton(32,64," Add New Sprite    ",NewSprite,NULL,NULL);
IG_TextButton(32,96," Pick a sprite     ",PickSprite,NULL,NULL);
IG_TextButton(32,128," Delete a sprite   ",DelSprite,NULL,NULL);

IG_AddKey(KEY_A,NewSprite);
IG_AddKey(KEY_P,PickSprite);
IG_AddKey(KEY_D,DelSprite);

DrawSunkBox3D(300,56,620,460);

setcolor(ITG_WHITE);
DrawScreenText(320,64,"Sprite name:");
SprName_Id = IG_InputButton(320,80,str32,GetSprName,NULL,NULL);

DrawScreenText(320,112,"Sprite filename:");
SprPath_Id = IG_InputButton(320,128,str32,GetSprPath,NULL,NULL);

IG_BlackPanel(VIEWX-1,VIEWY-1,258,258);

IG_AddKey(KEY_N,GetSprName);
IG_AddKey(KEY_F,GetSprPath);

SprUpdate();
}

// Callback for a null event

void Nothing()
{
return;
}


// Callback for Setting the sprite description

void GetSprName()
{
//if(curspr<SPtot)
    InputString(-1,-1,"Enter the new description of the sprite",32,SPlist[curspr].name);
SprUpdate();
}

// Callback for Setting the sprite filename

void GetSprPath()
{
char oldpath[1024];
strcpy(oldpath,SPlist[curspr].fname);
InputNameFromListWithFunc(-1,-1,"Choose an image file:",spr_total-1,sprites,5,SPlist[curspr].fname,0,0,NULL);
if(!SPlist[curspr].fname[0])
    strcpy(SPlist[curspr].fname,oldpath);
else
    {
    strlwr(SPlist[curspr].fname);
    if(SPlist[curspr].image)
		{
	    destroy_rle_sprite(SPlist[curspr].image);
        SPlist[curspr].image=NULL;
		}
	Init_Sprite(curspr);
//    SPedit[curspr].image = SPlist[GetNumForFilename(SPedit[curspr].fname)].image;
    }

SprUpdate();
}

// Function for updating the display

void SprUpdate()
{
int num;
// Update the sprite number

//sprintf(SprNoStr,"%d",curspr);
//IG_UpdateText(SprNo_Id,SprNoStr);

clear_to_color(gamewin,ITG_BLUE);

// Clear the sprite's name and path, set to proper value later, if valid no.
IG_UpdateText(SprPath_Id,"");
IG_UpdateText(SprName_Id,"");

ilog_quiet("A: %d\n",num);

if(!SPlist[curspr].name || !SPlist[curspr].fname)
	{
	ilog_quiet("A1: %x/%x\n",SPlist[curspr].name,SPlist[curspr].fname);
    num = -1;
	}
else
    {
    num = GetNumForFilename(SPlist[curspr].fname);
	ilog_quiet("A2: %x/%x = %d\n",SPlist[curspr].name,SPlist[curspr].fname,num);
    IG_UpdateText(SprPath_Id,SPlist[curspr].fname);
    IG_UpdateText(SprName_Id,SPlist[curspr].name);
    }

ilog_quiet("B: %d\n",num);

if(!SPlist[curspr].image)
    num=-1;

ilog_quiet("C: %d\n",num);

if(num==-1)
    {
//    DrawScreenText(VIEWX+8,VIEWY+8,"Does not exist");
	textout(gamewin,font,"Does not exist",8,8,ITG_WHITE);
	draw_sprite(swapscreen,gamewin,VIEWX,VIEWY);
    return;
    }

// Draw it

draw_rle_sprite(gamewin,SPlist[num].image,0,0);
draw_sprite(swapscreen,gamewin,VIEWX,VIEWY);
}

int GetNumForFilename(char *str)
{
int ctr;
if(!str)
	return -1;
for(ctr=0;ctr<spr_total;ctr++)
	if(SPlist[ctr].fname)
		if(!istricmp(SPlist[ctr].fname,str))
			return ctr;
return -1;
}

void PickSprite()
{
char name[128];
char **mlist;
long num=0,ctr;

mlist = (char **)M_get(spr_alloc,sizeof(char *));

for(ctr=0;ctr<spr_alloc;ctr++)
    if(SPlist[ctr].name && SPlist[ctr].fname)
        mlist[num++]=SPlist[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,SPlist[curspr].name);
InputNameFromListWithFunc(-1,-1,"Choose a sprite:",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,SPlist[curspr].name);

M_free(mlist);

for(ctr=0;ctr<spr_alloc;ctr++)
    if(SPlist[ctr].name != NULL)
    if(!stricmp(SPlist[ctr].name,name))
        {
        curspr=ctr;
        SprUpdate();
        return;
        }
Notify(-1,-1,"Oh Bugger!",NULL);
}

void NewSprite()
{
for(long ctr=0;ctr<spr_alloc;ctr++)
    if(!SPlist[ctr].name)
        {
        curspr=ctr;
        SPlist[curspr].fname = (char *)M_get(1,64);
        SPlist[curspr].name = (char *)M_get(1,64);
        strcpy(SPlist[curspr].fname,"NONE");
        strcpy(SPlist[curspr].name,"NONE");
        SprUpdate();

        GetSprPath();
        GetSprName();

        return;
        }

Notify(-1,-1,"Cannot create a new sprite.","Increase the value of MAX_SPRITES in SCRIPTER.INI");
}

void DelSprite()
{
int res;
char msg[80];

if(curspr == 0) // lame error message
    {
    Notify(-1,-1,"This sprite is special and cannot be deleted.","You may however change it to something else.");
    return;
    }

res = SpriteInUse(curspr);
if(res != -1)
    {
    sprintf(msg,"This sprite is used by sequence '%s'",SQlist[res].name);
    Notify(-1,-1,msg,"Please modify the sequence first");
    return;
    }

if(Confirm(-1,-1,"Really delete this sprite?",SPlist[curspr].name))
    {
	if(SPlist[curspr].image)
		{
		destroy_rle_sprite(SPlist[curspr].image);
        SPlist[curspr].image=NULL;
		}
//    SPlist[curspr].image.free();
    M_free(SPlist[curspr].fname);
    M_free(SPlist[curspr].name);
    SPlist[curspr].fname = NULL;
    SPlist[curspr].name = NULL;
    curspr=0;
    SprUpdate();
    }

}

int CMP(char *a,char *b)
{
return strcmp(a,b);
}

int SpriteInUse(int spr)
{
S_POOL *SPR;
int frame,ctr;

SPR = &SPlist[spr];
for(ctr=0;ctr<seq_alloc;ctr++)
   {
   if(SQlist[ctr].name)
      {
      for(frame=0;frame<SQlist[ctr].frames;frame++)
          if(SQlist[ctr].seq[frame] == SPR)
              return ctr;
      if(SQlist[ctr].overlay == SPR)
          return ctr;
      }
   }

return -1;
}

