// Overlay two 32x32 CEL files

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

unsigned char oldbuf[32][32];
unsigned char newbuf[32][32];
unsigned char bakbuf[32][32];
unsigned char palbuf[768];

#define putsh(a,b) {putc(a&255,b);putc((a>>8)&255,b);}

main(int argc,char *argv[])
{
FILE *fp;
unsigned int ID;
unsigned int w,h,ctr;
unsigned long sizey,cx,cy;

if(argc<3)
	{
	puts("Syntax:  merge <overlay> <backing1> [backing2] ...");
	return 0;
	}

fp=fopen(argv[1],"rb");
if(!fp)
	{
	puts("Could not open source file");
	exit(1);
	}
fseek(fp,32L,SEEK_SET);
fread(palbuf,768,1,fp);
fread(oldbuf,1024,1,fp);
fclose(fp);

// Copy source image to buffer
memcpy(bakbuf,oldbuf,1024);

for(ctr=2;ctr<argc;ctr++)
	{
	// Set up with source image
	memcpy(newbuf,bakbuf,1024);
	// Open second source file

	fp=fopen(argv[ctr],"rb");
	if(!fp)
		{
		puts("Could not open second file");
		exit(1);
		}
	fseek(fp,32L,SEEK_SET);
	fread(palbuf,768,1,fp);
	fread(oldbuf,1024,1,fp);
	fclose(fp);

	for(cy=0;cy<32;cy++)
		for(cx=0;cx<32;cx++)
			newbuf[cx][cy]=newbuf[cx][cy]?newbuf[cx][cy]:oldbuf[cx][cy];

	fp=fopen(argv[ctr],"wb");
	if(!fp)
		{
		puts("Could not write to second file");
		exit(1);
		}

	putsh(0x9119,fp);
	putsh(32,fp);
	putsh(32,fp);
	putsh(0,fp);	// x coord
	putsh(0,fp);	// y coord
	putc(8,fp);	// 8 bits/pixel
	putc(0,fp);	// 0 compression
	sizey=w*h;
	fwrite(&sizey,4,1,fp);
	fseek(fp,32L,SEEK_SET);
	fwrite(palbuf,768,1,fp);
	fwrite(newbuf,1024,1,fp);
	fclose(fp);
	}
return 1;
}



