AC_DEFUN([MD_CHECK_LIB_PKG],
  [
    MD_CHECK_ARG_WITH([$1], $PKG_CONFIG_LIBDIR,
      [
        PKGCONFIG_DIR=$path/lib/pkgconfig
        if test -d "$PKGCONFIG_DIR"; then
          ac_save_PKG_CONFIG_LIBDIR=$PKG_CONFIG_LIBDIR
          export PKG_CONFIG_LIBDIR=$PKGCONFIG_DIR
        fi
        PKG_CHECK_MODULES([$1], [$2 >= [$3]],
          [
            AC_DEFINE([HAVE_$1], [1], [Define to 1 if you have $1 (>= $3).])
            CPPFLAGS="`eval echo $CPPFLAGS \$$1_CFLAGS`"
            LDFLAGS="`eval echo $LDFLAGS \$$1_LIBS`"
            $4
          ],
          [
            $5
          ])
        if test -d "$PKGCONFIG_DIR"; then
          PKG_CONFIG_LIBDIR=$ac_save_PKG_CONFIG_LIBDIR
          test -z "$PKG_CONFIG_LIBDIR" && unset PKG_CONFIG_LIBDIR
        fi
     ])
  ])

AC_DEFUN([MD_CHECK_LIB_PKG_WARN],
  [
    MD_CHECK_LIB_PKG($1, $2, [$3], $4,
      [
        AC_MSG_WARN([$1 (>= [$3]) not found.])
        $5
      ])
  ])

AC_DEFUN([MD_CHECK_LIB_PKG_ERROR],
  [
    MD_CHECK_LIB_PKG($1, $2, [$3], $4,
      [
        AC_MSG_ERROR([$1 (>= [$3]) not found.])
        $5
      ])
  ])
