/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "graphic.h"
#include "about_logo.xpm"

static const char *credits[] = {
  "Andrea Marchesini aka bakunin\n<bakunin@autistici.org>\nCoder and Mantainer",
  "giskard\n<giskard@autistici.org>\nbeta tester, debian mantainer, translator",
  "lesion\n<lesion@neuroni.org>\nbeta tester",
  "arlan\n<arlan@indivia.net>\nbeta tester",
  "mkt0\n<mkt0@autistici.org>\nbetatester",
  "megabug\n<megabug@autistici.org>\nmegadebugger",
  "Quique\n<quique@sindominio.net>\nbeta tester, translator",
  "Guillaume Rousse\n<rousse@ccr.jussieu.fr>\nmandrake mantainer",
  "jigen\n<jigen@metalabs.org>\nbeta tester",
  "kino\n<kino@kino3d.com>\ngraphics",
  "aistu\n<aistu@hacari.org>\ngraphics",
  "l3chuck\n<l3chuck@autistici.org>\nbeta tester and manteiner window portage",
  "otted\n<otted@autistici.org>\nhomepage and graphics, translator",
  "elfo\n<elfo@autistici.org>\nbeta tester",
  "subvertao\n<subvertao@inventati.org>\nbeta tester",
  "bomboclat\n<bomboclat@autistici.org>\nbeta tester",
  "lucror\n<lucror@bastardi.org>\nbeta tester",
  "knom\n<knom@autistici.org>\ntranslator and man pages author",
  "zanzara\n<apemaia@paranoici.org>\ntranslator",
  NULL
};

static int about_t = 0;
static int about_timer = 0;
static GtkWidget *text = NULL;

gint about_timeout (gpointer);
void on_about_button_press_event (GtkWidget *, GdkEventButton *);

void
on_about_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  static GtkWidget *window = NULL;

  if (!window)
    {
      GtkWidget *box;
      GdkPixmap *pixmap;
      GdkPixmap *mask;
      GtkWidget *image;
      GtkWidget *scrolledwindow;
      GtkWidget *textarea;

      window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
      gtk_window_set_title (GTK_WINDOW (window), _("About SomaPlayer"));
      gtk_container_set_border_width (GTK_CONTAINER (window), 10);
      gtk_widget_realize (window);

      box = gtk_vbox_new (FALSE, 0);
      gtk_widget_show (box);
      gtk_container_add (GTK_CONTAINER (window), box);

      pixmap =
	gdk_pixmap_create_from_xpm_d (window->window, &mask, NULL,
				      about_logo);
      image = gtk_image_new_from_pixmap (pixmap, mask);
      gtk_widget_show (image);

      gtk_box_pack_start (GTK_BOX (box), image, TRUE, TRUE, 0);

      scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
      gtk_widget_show (scrolledwindow);
      gtk_box_pack_start (GTK_BOX (box), scrolledwindow, FALSE, FALSE, 0);
      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
				      GTK_POLICY_AUTOMATIC,
				      GTK_POLICY_AUTOMATIC);
      gtk_widget_set_size_request (scrolledwindow, -1, 100);

      textarea = gtk_text_view_new ();
      gtk_widget_show (textarea);
      gtk_container_add (GTK_CONTAINER (scrolledwindow), textarea);
      gtk_text_view_set_editable (GTK_TEXT_VIEW (textarea), FALSE);
      gtk_text_view_set_justification (GTK_TEXT_VIEW (textarea),
				       GTK_JUSTIFY_CENTER);
      gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (textarea), FALSE);
      gtk_text_view_set_pixels_above_lines (GTK_TEXT_VIEW (textarea), 5);
      gtk_text_view_set_pixels_below_lines (GTK_TEXT_VIEW (textarea), 5);
      gtk_text_view_set_left_margin (GTK_TEXT_VIEW (textarea), 5);
      gtk_text_view_set_right_margin (GTK_TEXT_VIEW (textarea), 5);

      text =
	(GtkWidget *) gtk_text_view_get_buffer (GTK_TEXT_VIEW (textarea));
      gtk_text_buffer_create_tag (GTK_TEXT_BUFFER (text), "text", "weight",
				  PANGO_WEIGHT_BOLD, "scale",
				  PANGO_SCALE_MEDIUM, NULL);

      g_signal_connect ((gpointer) window, "delete_event",
			G_CALLBACK (on_about_activate), text);

      gtk_signal_connect_object (GTK_OBJECT (textarea), "button_press_event",
				 GTK_SIGNAL_FUNC
				 (on_about_button_press_event), textarea);

    }

  if (!user_data)
    {
      about_timer = 0;
      about_timeout (NULL);
      gtk_widget_show (window);

      about_t = g_timeout_add (2000, about_timeout, NULL);
    }
  else
    {
      if (about_t)
	g_source_remove (about_t);

      about_t = 0;

      gtk_widget_hide (window);
    }
}

void
on_about_button_press_event (GtkWidget * w, GdkEventButton * event)
{

  if (event->button == 3 && about_timer > 1)
    about_timer -= 2;

  g_source_remove (about_t);
  about_timeout (NULL);
  about_t = g_timeout_add (2000, about_timeout, NULL);
}

/* Timeout for scrolling */
gint
about_timeout (gpointer data)
{
  GtkTextIter start;
  GtkTextIter end;

  gtk_text_buffer_get_start_iter (GTK_TEXT_BUFFER (text), &start);
  gtk_text_buffer_get_end_iter (GTK_TEXT_BUFFER (text), &end);

  gtk_text_buffer_delete (GTK_TEXT_BUFFER (text), &start, &end);

  gtk_text_buffer_get_iter_at_offset (GTK_TEXT_BUFFER (text), &start, 0);


  if (!credits[about_timer])
    about_timer = 0;

  gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER (text),
					    &start, credits[about_timer],
					    -1, "text", NULL);
  about_timer++;

  return TRUE;
}

/* EOF */
