/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "../audio.h"
#include "../other.h"
#include "graphic.h"
#include "gtkled.h"
#include "gtkledbar.h"

#ifdef ENABLE_SOMALIST
#include <somalist.h>
#endif

gtk_element_input *element_input;

GtkTargetEntry targetentries[] = {
  {"STRING", 0, 0}
  ,
  {"text/plain", 0, 0}
  ,
  {"application/x-rootwindow-drop", 0, 1}
};

GtkWidget *
create_winmain (void)
{
  GtkWidget *winmain;
  GtkWidget *vbox;
  GtkWidget *menubar;

  GtkWidget *image;

  GtkWidget *m_file;
  GtkWidget *m_file_menu;
  GtkWidget *m_file_item;
  GtkWidget *m_file_sep;

  gtk_element_input *change;

  GSList *input_group = NULL;

  GtkWidget *input;
  GtkWidget *input_menu;
#ifdef ENABLE_MIC
  GtkWidget *input_mic;
#endif
#ifdef ENABLE_DAEMON
  GtkWidget *input_daemon_input;
#endif
  GtkWidget *input_playlist;

  GtkWidget *output;
  GtkWidget *output_menu;
  GtkWidget *output_menu_s;
  GtkWidget *output_item;

  GtkWidget *m_help;
  GtkWidget *m_help_menu;
  GtkWidget *about;

#ifdef ENABLE_SOMALIST
  GtkWidget *playmenu;
  GtkWidget *playmenu_menu;
  GtkWidget *playmenu_item;
#endif

  GtkWidget *tools;
  GtkWidget *tools_menu;
  GtkWidget *tools_item;

  GtkWidget *table;
  GtkWidget *hbox_bottom_sx;
  GtkWidget *alignment;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *vseparator;
  GtkWidget *vbox2;
  GtkWidget *hbox_top;
  GtkWidget *b_prev;
  GtkWidget *b_play;
  GtkWidget *b_stop;
  GtkWidget *b_next;
  GtkAdjustment *adj_volume;
  GtkWidget *s_volume;
  GtkAdjustment *adj_balance;
  GtkWidget *s_balance;
  GtkWidget *textarea;
  GtkWidget *hbox_bottom_dx;
  GtkWidget *b_add;
  GtkWidget *b_remove;
  GtkWidget *scrolledwindow;
  GtkTooltips *tooltips;
  GtkAccelGroup *accel_group;

  GtkListStore *model;
  GtkCellRenderer *renderer;

  GtkWidget *add_m;
  GtkWidget *playlist_m;

  GtkWidget *output_list_sw;
  GtkWidget *output_list_m;
  GtkTreeSelection *selection;
  GtkTreeSelection *p_selection;

  char s[SIZE_BUFFER];
  struct stat st;

  accel_group = gtk_accel_group_new ();

  output_list_sw = create_output_list ();
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (output_list));

  winmain = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  sprintf (s, "%s - %s", NAME, VERSION);
  gtk_window_set_title (GTK_WINDOW (winmain), s);
  gtk_window_set_default_size (GTK_WINDOW (winmain), play->size_x,
			       play->size_y);
  gtk_window_set_default_icon_from_file(SOMAPLAYER_ICON, NULL);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (winmain), vbox);

  menubar = gtk_menu_bar_new ();
  gtk_widget_show (menubar);
  gtk_box_pack_start (GTK_BOX (vbox), menubar, FALSE, FALSE, 0);

  m_file = gtk_menu_item_new_with_mnemonic (_("_File"));
  gtk_widget_show (m_file);
  gtk_container_add (GTK_CONTAINER (menubar), m_file);

  m_file_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (m_file), m_file_menu);

  m_file_item = gtk_image_menu_item_new_with_mnemonic (_("_Open File"));
  gtk_widget_show (m_file_item);
  gtk_container_add (GTK_CONTAINER (m_file_menu), m_file_item);

  g_signal_connect ((gpointer) m_file_item, "activate",
		    G_CALLBACK (add_file_activate), NULL);

  image = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (m_file_item), image);

  m_file_item = gtk_image_menu_item_new_with_mnemonic (_("Open _Directory"));
  gtk_widget_show (m_file_item);
  gtk_container_add (GTK_CONTAINER (m_file_menu), m_file_item);

  g_signal_connect ((gpointer) m_file_item, "activate",
		    G_CALLBACK (add_dir_activate), NULL);

  image = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (m_file_item), image);

#ifdef ENABLE_CDAUDIO
  m_file_item = gtk_image_menu_item_new_with_mnemonic (_("Open _Cdaudio"));
  gtk_widget_show (m_file_item);
  gtk_container_add (GTK_CONTAINER (m_file_menu), m_file_item);

  g_signal_connect ((gpointer) m_file_item, "activate",
		    G_CALLBACK (add_cdaudio_activate), NULL);

  image = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (m_file_item), image);
#endif

  m_file_item = gtk_image_menu_item_new_with_mnemonic (_("Open _Stream"));
  gtk_widget_show (m_file_item);
  gtk_container_add (GTK_CONTAINER (m_file_menu), m_file_item);

  g_signal_connect ((gpointer) m_file_item, "activate",
		    G_CALLBACK (add_stream_activate), NULL);

  image = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (m_file_item), image);

  m_file_item = gtk_image_menu_item_new_with_mnemonic (_("Open _Playlist"));
  gtk_widget_show (m_file_item);
  gtk_container_add (GTK_CONTAINER (m_file_menu), m_file_item);

  g_signal_connect ((gpointer) m_file_item, "activate",
		    G_CALLBACK (add_pl_activate), NULL);

  image = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (m_file_item), image);

  m_file_sep = gtk_menu_item_new ();
  gtk_widget_show (m_file_sep);
  gtk_container_add (GTK_CONTAINER (m_file_menu), m_file_sep);
  gtk_widget_set_sensitive (m_file_sep, FALSE);

  m_file_item = gtk_image_menu_item_new_with_mnemonic (_("Save _Playlist"));
  gtk_widget_show (m_file_item);
  gtk_container_add (GTK_CONTAINER (m_file_menu), m_file_item);

  g_signal_connect ((gpointer) m_file_item, "activate",
		    G_CALLBACK (on_save_playlist_activate), NULL);

  image = gtk_image_new_from_stock ("gtk-save", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (m_file_item), image);

  m_file_item =
    gtk_image_menu_item_new_with_mnemonic (_("_Save Configuration"));
  gtk_widget_show (m_file_item);
  gtk_container_add (GTK_CONTAINER (m_file_menu), m_file_item);

  g_signal_connect ((gpointer) m_file_item, "activate",
		    G_CALLBACK (on_save_configuration_activate), NULL);

  image = gtk_image_new_from_stock ("gtk-save", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (m_file_item), image);

  m_file_sep = gtk_menu_item_new ();
  gtk_widget_show (m_file_sep);
  gtk_container_add (GTK_CONTAINER (m_file_menu), m_file_sep);
  gtk_widget_set_sensitive (m_file_sep, FALSE);

  m_file_item = gtk_image_menu_item_new_from_stock ("gtk-quit", accel_group);
  gtk_widget_show (m_file_item);
  gtk_container_add (GTK_CONTAINER (m_file_menu), m_file_item);

  g_signal_connect ((gpointer) m_file_item, "activate",
		    G_CALLBACK (on_quit_activate), NULL);

  input = gtk_menu_item_new_with_mnemonic (_("I_nput"));
  gtk_widget_show (input);
  gtk_container_add (GTK_CONTAINER (menubar), input);

  input_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (input), input_menu);

#ifdef ENABLE_MIC
  input_mic =
    gtk_radio_menu_item_new_with_mnemonic (input_group,
					   _("_Microphone/Line-in"));
  input_group =
    gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (input_mic));
  gtk_widget_show (input_mic);
  gtk_container_add (GTK_CONTAINER (input_menu), input_mic);
#endif

  input_playlist =
    gtk_radio_menu_item_new_with_mnemonic (input_group, _("_Playlist"));

  input_group =
    gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (input_playlist));
  gtk_widget_show (input_playlist);
  gtk_container_add (GTK_CONTAINER (input_menu), input_playlist);

#ifdef ENABLE_DAEMON
  input_daemon_input =
    gtk_radio_menu_item_new_with_mnemonic (input_group, _("_SdS"));

  input_group =
    gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (input_daemon_input));
  gtk_widget_show (input_daemon_input);
  gtk_container_add (GTK_CONTAINER (input_menu), input_daemon_input);
#endif

#ifdef ENABLE_MIC
  if (play->microphone)
    {
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (input_mic), TRUE);
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (input_playlist),
				      FALSE);
#ifdef ENABLE_DAEMON
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				      (input_daemon_input), FALSE);
#endif
    }
  else
#endif


#ifdef ENABLE_DAEMON
  if (play->daemon_input)
    {
#ifdef ENABLE_MIC
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (input_mic), FALSE);
#endif
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (input_playlist),
				      FALSE);
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				      (input_daemon_input), TRUE);
    }
#endif

  else
    {
#ifdef ENABLE_MIC
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (input_mic), FALSE);
#endif
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (input_playlist),
				      TRUE);
#ifdef ENABLE_DAEMON
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				      (input_daemon_input), FALSE);
#endif
    }

  output = gtk_menu_item_new_with_mnemonic (_("O_utputs"));
  gtk_widget_show (output);
  gtk_container_add (GTK_CONTAINER (menubar), output);

  output_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (output), output_menu);

  output_item = gtk_menu_item_new_with_mnemonic (_("_Add"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  output_menu_s = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (output_item), output_menu_s);

#ifdef ENABLE_AO
  output_item = gtk_menu_item_new_with_mnemonic (_("Audio"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu_s), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_ao_new_activate), NULL);
#endif

#ifdef ENABLE_DAEMON
  output_item =
    gtk_menu_item_new_with_mnemonic (_("Soma Distribuited Sound"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu_s), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_sds_new_activate), NULL);
#endif

#ifdef ENABLE_LAME
  output_item = gtk_menu_item_new_with_mnemonic (_("Encode Mp3"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu_s), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_lame_new_activate), NULL);
#endif

#ifdef ENABLE_OGG
  output_item = gtk_menu_item_new_with_mnemonic (_("Encode Ogg"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu_s), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_ogg_new_activate), NULL);
#endif

#ifdef ENABLE_SNDFILE
  output_item = gtk_menu_item_new_with_mnemonic (_("Write a file"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu_s), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_write_a_file_new_activate), NULL);
#endif

#ifdef ENABLE_STREAMING

#ifdef ENABLE_ICECAST
  output_item = gtk_menu_item_new_with_mnemonic (_("Icecast"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu_s), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_icecast_new_activate), NULL);
#endif

#ifdef ENABLE_ICECAST2
  output_item = gtk_menu_item_new_with_mnemonic (_("Icecast2"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu_s), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_icecast2_new_activate), NULL);
#endif

#ifdef ENABLE_SHOUTCAST
  output_item = gtk_menu_item_new_with_mnemonic (_("Shoutcast"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu_s), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_shoutcast_new_activate), NULL);
#endif

#endif

  output_item = gtk_menu_item_new_with_mnemonic (_("_Remove"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (output_list_select_remove), selection);

  output_item = gtk_menu_item_new_with_mnemonic (_("_Show"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (output_list_select_show), selection);

  output_item = gtk_menu_item_new_with_mnemonic (_("S_top/Start"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (output_list_select_stop), selection);

#ifdef ENABLE_SOMALIST
  playmenu = gtk_menu_item_new_with_mnemonic (_("_Playlist"));
  gtk_widget_show (playmenu);
  gtk_container_add (GTK_CONTAINER (menubar), playmenu);

  playmenu_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (playmenu), playmenu_menu);

  playmenu_item = gtk_menu_item_new_with_mnemonic (_("_Show Playlist Admin"));
  gtk_widget_show (playmenu_item);
  gtk_container_add (GTK_CONTAINER (playmenu_menu), playmenu_item);

  g_signal_connect ((gpointer) playmenu_item, "activate",
		    G_CALLBACK (spls_window_show), NULL);
#endif

  tools = gtk_menu_item_new_with_mnemonic (_("_Tools"));
  gtk_widget_show (tools);
  gtk_container_add (GTK_CONTAINER (menubar), tools);

  tools_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (tools), tools_menu);

  tools_item = gtk_menu_item_new_with_mnemonic (_("_Silence Trimming"));
  gtk_widget_show (tools_item);
  gtk_container_add (GTK_CONTAINER (tools_menu), tools_item);

  g_signal_connect ((gpointer) tools_item, "activate",
		    G_CALLBACK (on_trimming_activate), NULL);

  tools_item = gtk_check_menu_item_new_with_mnemonic (_("_Admin Interface"));
  gtk_widget_show (tools_item);
  gtk_container_add (GTK_CONTAINER (tools_menu), tools_item);

  if (play->admin)
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (tools_item), TRUE);
  else
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (tools_item), FALSE);

  g_signal_connect ((gpointer) tools_item, "activate",
		    G_CALLBACK (on_admin_activate), NULL);

  tools_item = gtk_check_menu_item_new_with_mnemonic (_("_Realtime Output"));
  gtk_widget_show (tools_item);
  gtk_container_add (GTK_CONTAINER (tools_menu), tools_item);

  if (play->norealtime)
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (tools_item), FALSE);
  else
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (tools_item), TRUE);

  g_signal_connect ((gpointer) tools_item, "activate",
		    G_CALLBACK (on_realtime_activate), NULL);

  m_help = gtk_menu_item_new_with_mnemonic (_("_Help"));
  gtk_widget_show (m_help);
  gtk_container_add (GTK_CONTAINER (menubar), m_help);

  m_help_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (m_help), m_help_menu);

  about = gtk_menu_item_new_with_mnemonic (_("_About..."));
  gtk_widget_show (about);
  gtk_container_add (GTK_CONTAINER (m_help_menu), about);

  table = gtk_table_new (0, 0, FALSE);
  gtk_widget_show (table);
  gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);

  ledbar_l = gtk_led_bar_new (20, GTK_ORIENTATION_VERTICAL);
  gtk_widget_show (ledbar_l);
  gtk_table_attach (GTK_TABLE (table), ledbar_l, 0, 1, 0, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  ledbar_r = gtk_led_bar_new (20, GTK_ORIENTATION_VERTICAL);
  gtk_widget_show (ledbar_r);
  gtk_table_attach (GTK_TABLE (table), ledbar_r, 1, 2, 0, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  hbox_bottom_sx = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox_bottom_sx);
  gtk_table_attach (GTK_TABLE (table), hbox_bottom_sx, 2, 3, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  tooltips = gtk_tooltips_new ();
  b_random = gtk_toggle_button_new ();
  gtk_widget_show (b_random);
  gtk_tooltips_set_tip (tooltips, b_random,
			_("Random sequence of audio files."), NULL);
  gtk_box_pack_start (GTK_BOX (hbox_bottom_sx), b_random, TRUE, TRUE, 0);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (b_random), alignment);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (alignment), hbox);

  image = gtk_image_new_from_stock ("gtk-select-color", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Random"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  tooltips = gtk_tooltips_new ();
  b_repeat = gtk_toggle_button_new ();
  gtk_widget_show (b_repeat);
  gtk_tooltips_set_tip (tooltips, b_repeat, _("Repeat sequence audio files."),
			NULL);
  gtk_box_pack_start (GTK_BOX (hbox_bottom_sx), b_repeat, TRUE, TRUE, 0);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (b_repeat), alignment);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (alignment), hbox);

  image = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Repeat"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  vseparator = gtk_vseparator_new ();
  gtk_widget_show (vseparator);
  gtk_table_attach (GTK_TABLE (table), vseparator, 3, 4, 0, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_table_attach (GTK_TABLE (table), vbox2, 2, 3, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  hbox_top = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox_top);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox_top, FALSE, FALSE, 0);

  b_prev = gtk_button_new ();
  gtk_widget_show (b_prev);
  gtk_box_pack_start (GTK_BOX (hbox_top), b_prev, FALSE, FALSE, 0);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (b_prev), alignment);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (alignment), hbox);

  image = gtk_image_new_from_stock ("gtk-go-back", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Back"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  b_play = gtk_button_new ();
  gtk_widget_show (b_play);
  gtk_box_pack_start (GTK_BOX (hbox_top), b_play, FALSE, FALSE, 0);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (b_play), alignment);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (alignment), hbox);

  image = gtk_image_new_from_stock ("gtk-execute", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Play"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  b_stop = gtk_button_new ();
  gtk_widget_show (b_stop);
  gtk_box_pack_start (GTK_BOX (hbox_top), b_stop, FALSE, FALSE, 0);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (b_stop), alignment);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (alignment), hbox);

  image = gtk_image_new_from_stock ("gtk-dialog-error", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Stop"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  b_next = gtk_button_new ();
  gtk_widget_show (b_next);
  gtk_box_pack_start (GTK_BOX (hbox_top), b_next, FALSE, FALSE, 0);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (b_next), alignment);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (alignment), hbox);

  image = gtk_image_new_from_stock ("gtk-go-forward", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Next"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, TRUE, 0);

  label = gtk_label_new (_("Volume:"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  tooltips = gtk_tooltips_new ();

  adj_volume =
    (GtkAdjustment *) gtk_adjustment_new ((gdouble) play->volume, 0, 100, 5,
					  5, 0);
  s_volume = gtk_hscale_new (adj_volume);
  gtk_widget_show (s_volume);
  gtk_tooltips_set_tip (tooltips, s_volume, _("Change the output volume."),
			NULL);
  gtk_box_pack_start (GTK_BOX (hbox), s_volume, TRUE, TRUE, 0);
  gtk_scale_set_value_pos (GTK_SCALE (s_volume), GTK_POS_RIGHT);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, TRUE, 0);

  label = gtk_label_new (_("Balance:"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  tooltips = gtk_tooltips_new ();
  adj_balance =
    (GtkAdjustment *)
    gtk_adjustment_new ((gdouble)
			((play->balance + 100) !=
			 0 ? (play->balance + 100) / 2 : 0), 0, 100, 5, 5, 0);
  s_balance = gtk_hscale_new (adj_balance);
  gtk_widget_show (s_balance);
  gtk_tooltips_set_tip (tooltips, s_balance, _("Change the output balance."),
			NULL);
  gtk_box_pack_start (GTK_BOX (hbox), s_balance, TRUE, TRUE, 0);
  gtk_scale_set_value_pos (GTK_SCALE (s_balance), GTK_POS_RIGHT);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow);
  gtk_box_pack_start (GTK_BOX (vbox2), scrolledwindow, FALSE, FALSE, 0);
  gtk_widget_set_size_request (scrolledwindow, 190, 80);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
				  GTK_POLICY_NEVER, GTK_POLICY_NEVER);

  textarea = gtk_text_view_new ();
  gtk_widget_show (textarea);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), textarea);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (textarea), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (textarea), FALSE);
  text = (GtkWidget *) gtk_text_view_get_buffer (GTK_TEXT_VIEW (textarea));

  gtk_box_pack_start (GTK_BOX (vbox2), output_list_sw, TRUE, TRUE, 0);

  hbox_bottom_dx = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox_bottom_dx);
  gtk_table_attach (GTK_TABLE (table), hbox_bottom_dx, 4, 5, 1, 2,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  tooltips = gtk_tooltips_new ();
  b_add = gtk_button_new ();
  gtk_widget_show (b_add);
  gtk_tooltips_set_tip (tooltips, b_add, _("Add files or directories"), NULL);
  gtk_box_pack_start (GTK_BOX (hbox_bottom_dx), b_add, TRUE, TRUE, 0);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (b_add), alignment);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (alignment), hbox);

  image = gtk_image_new_from_stock ("gtk-add", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Add"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  tooltips = gtk_tooltips_new ();
  b_remove = gtk_button_new ();
  gtk_widget_show (b_remove);
  gtk_tooltips_set_tip (tooltips, b_remove, _("Remove files or directories"),
			NULL);
  gtk_box_pack_start (GTK_BOX (hbox_bottom_dx), b_remove, TRUE, TRUE, 0);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (b_remove), alignment);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (alignment), hbox);

  image = gtk_image_new_from_stock ("gtk-remove", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Remove"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow);
  gtk_table_attach (GTK_TABLE (table), scrolledwindow, 4, 5, 0, 1,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_widget_set_size_request (scrolledwindow, 250, -1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  model =
    gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_STRING);
  playlist =
    (GtkWidget *) gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
  gtk_tree_view_set_enable_search (GTK_TREE_VIEW (playlist), FALSE);
  p_selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (playlist));
  gtk_tree_selection_set_mode (p_selection, GTK_SELECTION_MULTIPLE);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (playlist), TRUE);

  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (playlist), -1,
					       _("Q"), renderer,
					       "text", 2, NULL);

  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (playlist), -1,
					       _("Playlist"), renderer,
					       "text", 0, NULL);

  gtk_widget_show (playlist);
  g_object_unref (model);

  gtk_container_add (GTK_CONTAINER (scrolledwindow), playlist);

  statusbar = gtk_statusbar_new ();
  statusbar_id =
    gtk_statusbar_get_context_id (GTK_STATUSBAR (statusbar),
				  _("SomaPlayer start..."));

  gtk_widget_show (statusbar);
  gtk_box_pack_start (GTK_BOX (vbox), statusbar, FALSE, FALSE, 0);

  output_list_m = create_output_list_menu (selection);
  add_m = add_menu ();
  playlist_m = playlist_menu ();

  g_signal_connect ((gpointer) winmain, "destroy",
		    G_CALLBACK (on_quit_activate), NULL);

  if (!(change = (gtk_element_input *) malloc (sizeof (gtk_element_input))))
    fatal (_("Error: memory."));

  element_input = change;

  change->playlist = playlist;
  change->buttons = hbox_bottom_dx;
  change->volume = s_volume;
  change->balance = s_balance;
  change->repeat = b_repeat;
  change->random = b_random;

  change->t_playlist = input_playlist;
#ifdef ENABLE_MIC
  change->t_microphone = input_mic;
#endif

#ifdef ENABLE_DAEMON
  change->t_daemon_input = input_daemon_input;
#endif

#ifdef ENABLE_MIC
  g_signal_connect ((gpointer) input_mic, "activate",
		    G_CALLBACK (on_mic_activate),
		    (gtk_element_input *) change);
#endif

  g_signal_connect ((gpointer) input_playlist, "activate",
		    G_CALLBACK (on_playlist_activate),
		    (gtk_element_input *) change);

#ifdef ENABLE_DAEMON
  g_signal_connect ((gpointer) input_daemon_input, "activate",
		    G_CALLBACK (on_daemon_input_activate),
		    (gtk_element_input *) change);
#endif

  gtk_signal_connect_object (GTK_OBJECT (output_list), "button_press_event",
			     GTK_SIGNAL_FUNC (output_list_m_show),
			     output_list_m);

  g_signal_connect ((gpointer) about, "activate",
		    G_CALLBACK (on_about_activate), NULL);
  g_signal_connect ((gpointer) b_prev, "clicked",
		    G_CALLBACK (on_b_prev_clicked), NULL);
  g_signal_connect ((gpointer) b_play, "clicked",
		    G_CALLBACK (on_b_play_clicked), NULL);
  g_signal_connect ((gpointer) b_stop, "clicked",
		    G_CALLBACK (on_b_stop_clicked), NULL);
  g_signal_connect ((gpointer) b_next, "clicked",
		    G_CALLBACK (on_b_next_clicked), NULL);
  g_signal_connect ((gpointer) s_volume, "value_changed",
		    G_CALLBACK (on_s_volume_value_changed), NULL);
  g_signal_connect ((gpointer) s_balance, "value_changed",
		    G_CALLBACK (on_s_balance_value_changed), NULL);
  g_signal_connect ((gpointer) b_random, "toggled",
		    G_CALLBACK (on_b_random_toggled), NULL);
  g_signal_connect ((gpointer) b_repeat, "toggled",
		    G_CALLBACK (on_b_repeat_toggled), NULL);
  g_signal_connect ((gpointer) b_remove, "clicked",
		    G_CALLBACK (on_b_remove_clicked), p_selection);
  g_signal_connect (GTK_OBJECT (b_add), "button_press_event",
			     GTK_SIGNAL_FUNC (add_menu_popup), add_m);
  g_signal_connect (GTK_OBJECT (playlist), "button-press-event",
		    GTK_SIGNAL_FUNC (playlist_menu_popup), playlist_m);

  g_signal_connect ((gpointer) playlist, "drag_data_get",
		    G_CALLBACK (playlist_drag_get), NULL);
  g_signal_connect ((gpointer) playlist, "drag_data_received",
		    G_CALLBACK (playlist_drop), NULL);
  g_signal_connect ((gpointer) playlist, "drag_begin",
		    G_CALLBACK (playlist_drag_begin), NULL);
  g_signal_connect ((gpointer) playlist, "drag_end",
		    G_CALLBACK (playlist_drag_end), NULL);

  gtk_drag_source_set (playlist, GDK_BUTTON1_MASK | GDK_BUTTON3_MASK,
		       targetentries, 3, GDK_ACTION_COPY | GDK_ACTION_MOVE);

  gtk_drag_dest_set (playlist, GTK_DEST_DEFAULT_ALL, targetentries, 3,
		     GDK_ACTION_COPY | GDK_ACTION_MOVE);

  g_signal_connect ((gpointer) winmain, "key-press-event",
		    GTK_SIGNAL_FUNC (playlist_key_event), p_selection);

  if (!lstat (SOMAPLAYER_ICON, &st))
    {
      GdkPixbuf *pb;

      pb = gdk_pixbuf_new_from_file (SOMAPLAYER_ICON, NULL);
      gtk_drag_source_set_icon_pixbuf (playlist, pb);
    }

  gtk_window_add_accel_group (GTK_WINDOW (winmain), accel_group);

  return winmain;
}

/* EOF */
