/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import antlr.Token;
import com.puppycrawl.tools.checkstyle.BlockOption;
import com.puppycrawl.tools.checkstyle.ClassResolver;
import com.puppycrawl.tools.checkstyle.Configuration;
import com.puppycrawl.tools.checkstyle.JavadocTag;
import com.puppycrawl.tools.checkstyle.LeftCurlyOption;
import com.puppycrawl.tools.checkstyle.LineText;
import com.puppycrawl.tools.checkstyle.MethodSignature;
import com.puppycrawl.tools.checkstyle.MyCommonAST;
import com.puppycrawl.tools.checkstyle.MyModifierSet;
import com.puppycrawl.tools.checkstyle.MyToken;
import com.puppycrawl.tools.checkstyle.MyVariable;
import com.puppycrawl.tools.checkstyle.PadOption;
import com.puppycrawl.tools.checkstyle.RightCurlyOption;
import com.puppycrawl.tools.checkstyle.Scope;
import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.WrapOpOption;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

class Verifier {
    private static final String MATCH_JAVADOC_ARG_PAT = "@(throws|exception|param)\\s+(\\S+)\\s+\\S";
    private static final RE MATCH_JAVADOC_ARG = Verifier.createRE("@(throws|exception|param)\\s+(\\S+)\\s+\\S");
    private static final String MATCH_JAVADOC_MULTILINE_START_PAT = "@(throws|exception|param)\\s+(\\S+)\\s*$";
    private static final RE MATCH_JAVADOC_MULTILINE_START = Verifier.createRE("@(throws|exception|param)\\s+(\\S+)\\s*$");
    private static final String MATCH_JAVADOC_MULTILINE_CONT_PAT = "(\\*/|@|[^\\s\\*])";
    private static final RE MATCH_JAVADOC_MULTILINE_CONT = Verifier.createRE("(\\*/|@|[^\\s\\*])");
    private static final String END_JAVADOC = "*/";
    private static final String NEXT_TAG = "@";
    private static final String MATCH_JAVADOC_NOARG_PAT = "@(return|see|author)\\s+\\S";
    private static final RE MATCH_JAVADOC_NOARG = Verifier.createRE("@(return|see|author)\\s+\\S");
    private static final String MATCH_JAVADOC_AUTHOR_PAT = "@author\\s+\\S";
    private static final RE MATCH_JAVADOC_AUTHOR = Verifier.createRE("@author\\s+\\S");
    private final Stack mInInterface = new Stack();
    private final Stack mInScope = new Stack();
    private int mMethodBlockLevel = 0;
    private final List mMessages = new ArrayList();
    private String[] mLines;
    private String mPkgName;
    private final Map mComments = new HashMap();
    private final Set mImports = new HashSet();
    private final Set mReferenced = new HashSet();
    private final Configuration mConfig;
    static /* synthetic */ Class class$java$lang$RuntimeException;

    Verifier(Configuration aConfig) {
        this.mConfig = aConfig;
    }

    LineText[] getMessages() {
        this.checkImports();
        Collections.sort(this.mMessages);
        return this.mMessages.toArray(new LineText[this.mMessages.size()]);
    }

    void clearMessages() {
        this.mLines = null;
        this.mPkgName = null;
        this.mInInterface.clear();
        this.mInScope.clear();
        this.mMessages.clear();
        this.mComments.clear();
        this.mImports.clear();
        this.mReferenced.clear();
        this.mMethodBlockLevel = 0;
    }

    void setLines(String[] aLines) {
        this.mLines = aLines;
        this.checkHeader();
        int i = 0;
        while (i < this.mLines.length) {
            int tabPosition;
            String line = this.mLines[i];
            int realLength = Utils.lengthExpandedTabs(line, line.length(), this.mConfig.getTabWidth());
            if (!(realLength <= this.mConfig.getMaxLineLength() || this.mConfig.getIgnoreLineLengthRegexp().match(line) || this.mConfig.isIgnoreImportLength() && line.trim().startsWith("import"))) {
                this.log(i + 1, "line longer than " + this.mConfig.getMaxLineLength() + " characters");
            }
            if (!this.mConfig.isAllowTabs() && (tabPosition = this.mLines[i].indexOf(9)) != -1) {
                this.log(i + 1, tabPosition, "line contains a tab character");
            }
            ++i;
        }
        if (this.mLines.length > this.mConfig.getMaxFileLength()) {
            this.log(1, "file length is " + this.mLines.length + " lines (max allowed is " + this.mConfig.getMaxFileLength() + ").");
        }
    }

    void verifyMethod(MethodSignature aSig) {
        Scope methodScope;
        if (!aSig.isConstructor() && !this.mConfig.getMethodRegexp().match(aSig.getName().getText())) {
            this.log(aSig.getName().getLineNo(), aSig.getName().getColumnNo(), "method name '" + aSig.getName().getText() + "' must match pattern '" + this.mConfig.getMethodPat() + "'.");
        }
        Iterator it = aSig.getParams().iterator();
        while (it.hasNext()) {
            this.checkParameter((LineText)it.next());
        }
        this.checkModOrder(aSig.getModSet());
        if (!this.mConfig.isIgnorePublicInInterface() && this.inInterfaceBlock() && aSig.getModSet().containsPublic()) {
            this.log(aSig.getModSet().getFirstLineNo(), aSig.getModSet().getFirstColNo(), "redundant 'public' modifier.");
        }
        if (this.inInterfaceBlock() && aSig.getModSet().containsAbstract()) {
            this.log(aSig.getModSet().getFirstLineNo(), aSig.getModSet().getFirstColNo(), "redundant 'abstract' modifier.");
        }
        Scope scope = methodScope = this.inInterfaceBlock() ? Scope.PUBLIC : aSig.getModSet().getVisibilityScope();
        if (!this.inCheckScope(methodScope)) {
            return;
        }
        String[] jd = this.getJavadocBefore(aSig.getFirstLineNo() - 1);
        if (jd == null) {
            this.log(aSig.getFirstLineNo(), aSig.getFirstColNo(), "method is missing a Javadoc comment.");
        } else {
            List tags = this.getMethodTags(jd, aSig.getFirstLineNo() - 1);
            if (tags.size() != 1 || !((JavadocTag)tags.get(0)).isSeeTag()) {
                this.checkParamTags(tags, aSig.getParams());
                this.checkThrowsTags(tags, aSig.getThrows());
                if (aSig.isFunction()) {
                    this.checkReturnTag(tags, aSig.getFirstLineNo());
                }
                Iterator it2 = tags.iterator();
                while (it2.hasNext()) {
                    JavadocTag jt = (JavadocTag)it2.next();
                    if (jt.isSeeTag()) continue;
                    this.log(jt.getLineNo(), "Unused Javadoc tag.");
                }
            }
        }
    }

    void verifyType(MyModifierSet aMods, MyCommonAST aType) {
        Scope typeScope;
        if (!this.mConfig.getTypeRegexp().match(aType.getText())) {
            this.log(aType.getLineNo(), aType.getColumnNo(), "type name '" + aType.getText() + "' must match pattern '" + this.mConfig.getTypePat() + "'.");
        }
        this.checkModOrder(aMods);
        Scope scope = typeScope = this.inInterfaceBlock() ? Scope.PUBLIC : aMods.getVisibilityScope();
        if (!this.inCheckScope(typeScope)) {
            return;
        }
        int lineNo = aMods.size() > 0 ? aMods.getFirstLineNo() : aType.getLineNo();
        Object[] jd = this.getJavadocBefore(lineNo - 1);
        if (jd == null) {
            this.log(lineNo, "type is missing a Javadoc comment.");
        } else if (!this.mConfig.isAllowNoAuthor() && this.mInScope.size() == 0 && MATCH_JAVADOC_AUTHOR.grep(jd).length == 0) {
            this.log(lineNo, "type Javadoc comment is missing an @author tag.");
        }
    }

    void verifyVariable(MyVariable aVar) {
        if (this.inMethodBlock()) {
            this.checkVariable(aVar, this.mConfig.getLocalVarRegexp(), this.mConfig.getLocalVarPat());
            return;
        }
        MyModifierSet mods = aVar.getModifierSet();
        Scope declaredScope = mods.getVisibilityScope();
        Scope variableScope = this.inInterfaceBlock() ? Scope.PUBLIC : declaredScope;
        this.checkModOrder(mods);
        if (this.inCheckScope(variableScope) && this.getJavadocBefore(aVar.getStartLineNo() - 1) == null) {
            this.log(aVar.getLineNo(), aVar.getColumnNo() - 1, "variable '" + aVar.getText() + "' missing Javadoc.");
        }
        if (this.inInterfaceBlock()) {
            this.checkVariable(aVar, this.mConfig.getStaticFinalRegexp(), this.mConfig.getStaticFinalPat());
        } else {
            boolean isPckg = Scope.PACKAGE.equals(variableScope);
            boolean isProt = Scope.PROTECTED.equals(variableScope);
            if (mods.containsStatic()) {
                if (mods.containsFinal()) {
                    if (!"serialVersionUID".equals(aVar.getText())) {
                        this.checkVariable(aVar, this.mConfig.getStaticFinalRegexp(), this.mConfig.getStaticFinalPat());
                    }
                } else if (Scope.PRIVATE.equals(variableScope) || this.mConfig.isAllowPackage() && isPckg || this.mConfig.isAllowProtected() && isProt) {
                    this.checkVariable(aVar, this.mConfig.getStaticRegexp(), this.mConfig.getStaticPat());
                } else {
                    this.log(aVar.getLineNo(), aVar.getColumnNo() - 1, "variable '" + aVar.getText() + "' must be private and have accessor methods.");
                }
            } else if (Scope.PRIVATE.equals(variableScope) || this.mConfig.isAllowPackage() && isPckg || this.mConfig.isAllowProtected() && isProt) {
                this.checkVariable(aVar, this.mConfig.getMemberRegexp(), this.mConfig.getMemberPat());
            } else if (!mods.containsPublic() || !this.mConfig.getPublicMemberRegexp().match(aVar.getText())) {
                this.log(aVar.getLineNo(), aVar.getColumnNo() - 1, "variable '" + aVar.getText() + "' must be private and have accessor methods.");
            }
        }
    }

    void reportNeedBraces(Token aStmt) {
        if (!this.mConfig.isIgnoreBraces()) {
            this.log(aStmt.getLine(), "'" + aStmt.getText() + "' construct must use '{}'s.");
        }
    }

    void verifyWSAroundEnd(int aLineNo, int aColNo, String aText) {
        this.verifyWSAroundBegin(aLineNo, aColNo - aText.length(), aText);
    }

    void verifyWSAroundBegin(int aLineNo, int aColNo, String aText) {
        if (this.mConfig.isIgnoreWhitespace()) {
            return;
        }
        String line = this.mLines[aLineNo - 1];
        int before = aColNo - 2;
        int after = aColNo + aText.length() - 1;
        if (before >= 0 && !Character.isWhitespace(line.charAt(before))) {
            this.log(aLineNo, before + 1, "'" + aText + "' is not preceeded with whitespace.");
        }
        if (after < line.length() && !Character.isWhitespace(line.charAt(after))) {
            this.log(aLineNo, after, "'" + aText + "' is not followed by whitespace.");
        }
    }

    void verifyNoWSAfter(MyCommonAST aAST) {
        if (this.mConfig.isIgnoreWhitespace()) {
            return;
        }
        String line = this.mLines[aAST.getLineNo() - 1];
        int after = aAST.getColumnNo() + aAST.getText().length();
        if (after >= line.length() || Character.isWhitespace(line.charAt(after))) {
            this.log(aAST.getLineNo(), after, "'" + aAST.getText() + "' is followed by whitespace.");
        }
    }

    void verifyNoWSBefore(MyCommonAST aAST) {
        if (this.mConfig.isIgnoreWhitespace()) {
            return;
        }
        String line = this.mLines[aAST.getLineNo() - 1];
        int before = aAST.getColumnNo() - 1;
        if (before < 0 || Character.isWhitespace(line.charAt(before))) {
            this.log(aAST.getLineNo(), before, "'" + aAST.getText() + "' is preceeded with whitespace.");
        }
    }

    void verifyDot(MyCommonAST aAST) {
        int after;
        if (this.mConfig.isIgnoreWhitespace()) {
            return;
        }
        String line = this.mLines[aAST.getLineNo() - 1];
        int before = aAST.getColumnNo() - 1;
        if (before >= 0 && Character.isWhitespace(line.charAt(before))) {
            int i = 0;
            while (i < before) {
                if (!Character.isWhitespace(line.charAt(i))) {
                    this.log(aAST.getLineNo(), aAST.getColumnNo() - 1, "'.' is preceeded with whitespace.");
                    break;
                }
                ++i;
            }
        }
        if ((after = aAST.getColumnNo() + 1) < line.length() && Character.isWhitespace(line.charAt(after))) {
            int i = after + 1;
            while (i < line.length()) {
                if (!Character.isWhitespace(line.charAt(i))) {
                    this.log(aAST.getLineNo(), after, "'.' is followed by whitespace.");
                    break;
                }
                ++i;
            }
        }
    }

    void verifyWSAfter(int aLineNo, int aColNo, MyToken aConstruct) {
        this.verifyWSAfter(aLineNo, aColNo, aConstruct, "");
    }

    void verifyWSAfter(int aLineNo, int aColNo, MyToken aConstruct, String aAllow) {
        this.checkWSAfter(aLineNo, aColNo, aConstruct, aAllow);
    }

    void verifyMethodLength(int aLineNo, int aLength) {
        if (aLength > this.mConfig.getMaxMethodLength()) {
            this.log(aLineNo, "method length is " + aLength + " lines (max allowed is " + this.mConfig.getMaxMethodLength() + ").");
        }
    }

    void verifyLCurlyMethod(int aMethodLine, MyCommonAST aBrace) {
        this.checkLCurly(aMethodLine, aBrace, this.mConfig.getLCurlyMethod());
    }

    void verifyLCurlyType(int aTypeLine, MyCommonAST aBrace) {
        this.checkLCurly(aTypeLine, aBrace, this.mConfig.getLCurlyType());
    }

    void verifyLCurlyOther(int aOtherLine, MyCommonAST aBrace) {
        this.checkLCurly(aOtherLine, aBrace, this.mConfig.getLCurlyOther());
    }

    void verifyRCurly(MyCommonAST aBrace, int aStartLine) {
        this.verifyWSAroundBegin(aBrace.getLineNo(), aBrace.getColumnNo() + 1, aBrace.getText());
        if (this.mConfig.getRCurly() == RightCurlyOption.SAME && aBrace.getLineNo() != aStartLine) {
            this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "'}' should be on the same line.");
        } else if (this.mConfig.getRCurly() == RightCurlyOption.ALONE && aBrace.getLineNo() == aStartLine) {
            this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "'}' should be alone on a line.");
        }
    }

    void verifyLParen(int aLineNo, int aColNo) {
        if (this.mConfig.isIgnoreWhitespace() || PadOption.IGNORE == this.mConfig.getParenPadOption()) {
            return;
        }
        int after = aColNo - 1;
        String line = this.mLines[aLineNo - 1];
        if (after < line.length() && Character.isWhitespace(line.charAt(after))) {
            this.log(aLineNo, after, "'(' is followed by whitespace.");
        }
    }

    void verifyRParen(int aLineNo, int aColNo) {
        if (this.mConfig.isIgnoreWhitespace() || PadOption.IGNORE == this.mConfig.getParenPadOption()) {
            return;
        }
        String line = this.mLines[aLineNo - 1];
        int before = aColNo - 3;
        if (before >= 0 && Character.isWhitespace(line.charAt(before)) && !Utils.whitespaceBefore(before, line)) {
            this.log(aLineNo, before, "')' is preceeded by whitespace.");
        }
    }

    void verifyConstructorLength(int aLineNo, int aLength) {
        if (aLength > this.mConfig.getMaxConstructorLength()) {
            this.log(aLineNo, "constructor length is " + aLength + " lines (max allowed is " + this.mConfig.getMaxConstructorLength() + ").");
        }
    }

    void reportCPPComment(int aStartLineNo, int aStartColNo) {
        String cmt = this.mLines[aStartLineNo - 1].substring(aStartColNo);
        if (this.mConfig.getTodoRegexp().match(cmt)) {
            this.log(aStartLineNo, "Comment matches to-do format '" + this.mConfig.getTodoPat() + "'.");
        }
    }

    void reportCComment(int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        String[] cc = this.extractCComment(aStartLineNo, aStartColNo, aEndLineNo, aEndColNo);
        if (this.mLines[aStartLineNo - 1].indexOf("/**", aStartColNo) != -1) {
            this.mComments.put(new Integer(aEndLineNo - 1), cc);
        }
        int i = 0;
        while (i < cc.length) {
            if (this.mConfig.getTodoRegexp().match(cc[i])) {
                this.log(aStartLineNo + i, "Comment matches to-do format '" + this.mConfig.getTodoPat() + "'.");
            }
            ++i;
        }
    }

    void reportReference(String aType) {
        this.mReferenced.add(aType);
    }

    void reportPackageName(String aName) {
        this.mPkgName = aName;
    }

    void reportImport(int aLineNo, String aType) {
        if (!this.mConfig.isIgnoreImports()) {
            Iterator it = this.mImports.iterator();
            while (it.hasNext()) {
                LineText lt = (LineText)it.next();
                if (!aType.equals(lt.getText())) continue;
                this.log(aLineNo, "Duplicate import to line " + lt.getLineNo() + ".");
            }
        }
        this.mImports.add(new LineText(aLineNo, aType));
    }

    void reportStarImport(int aLineNo, String aPkg) {
        if (!this.mConfig.isIgnoreImports()) {
            this.log(aLineNo, "Avoid using the '.*' form of import.");
        }
        this.mImports.add(new LineText(aLineNo, aPkg));
    }

    void reportStartTypeBlock(Scope aScope, boolean aIsInterface) {
        this.mInScope.push(aScope);
        this.mInInterface.push(aIsInterface ? Boolean.TRUE : Boolean.FALSE);
    }

    void reportEndTypeBlock() {
        this.mInScope.pop();
        this.mInInterface.pop();
    }

    void reportStartMethodBlock() {
        ++this.mMethodBlockLevel;
    }

    void reportEndMethodBlock() {
        --this.mMethodBlockLevel;
    }

    void reportTryBlock(MyCommonAST[] aBraces, boolean aNoStmt) {
        this.checkBlock("try", this.mConfig.getTryBlock(), aBraces, aNoStmt);
    }

    void reportCatchBlock(MyCommonAST[] aBraces, boolean aNoStmt) {
        this.checkBlock("catch", this.mConfig.getCatchBlock(), aBraces, aNoStmt);
    }

    void reportFinallyBlock(MyCommonAST[] aBraces, boolean aNoStmt) {
        this.checkBlock("finally", this.mConfig.getFinallyBlock(), aBraces, aNoStmt);
    }

    void reportInstantiation(MyCommonAST aNewAST, LineText aTypeName) {
        String typeName = aTypeName.getText();
        int lineNo = aNewAST.getLineNo();
        int colNo = aNewAST.getColumnNo();
        String fqClassName = this.getIllegalInstantiation(typeName);
        if (fqClassName != null) {
            this.log(lineNo, colNo, "Avoid instantiation of " + fqClassName);
        }
    }

    void verifyOpEnd(int aLineNo, int aColNo, String aText) {
        this.verifyOpBegin(aLineNo, aColNo - aText.length(), aText);
    }

    void verifyOpBegin(int aLineNo, int aColNo, String aText) {
        this.verifyWSAroundBegin(aLineNo, aColNo, aText);
        if (this.mConfig.getWrapOpOption() != WrapOpOption.IGNORE && !aText.equals(this.mLines[aLineNo - 1].trim()) && this.mLines[aLineNo - 1].substring(aColNo + aText.length() - 1).trim().length() == 0) {
            this.log(aLineNo, aColNo - 1, "'" + aText + "' should be on a new line.");
        }
    }

    void verifyLongEll(int aLineNo, int aColNo) {
        if (!this.mConfig.isIgnoreLongEll() && this.mLines[aLineNo - 1].charAt(aColNo) == 'l') {
            this.log(aLineNo, aColNo, "Should use uppercase 'L'.");
        }
    }

    private boolean inCheckScope(Scope aScope) {
        Scope configScope = this.mConfig.getJavadocScope();
        boolean retVal = aScope.isIn(configScope);
        Iterator scopeIterator = ((AbstractList)this.mInScope).iterator();
        while (retVal && scopeIterator.hasNext()) {
            Scope stackScope = (Scope)scopeIterator.next();
            retVal = stackScope.isIn(configScope);
        }
        return retVal;
    }

    private static RE createRE(String aPattern) {
        RE retVal = null;
        try {
            retVal = Utils.getRE(aPattern);
        }
        catch (RESyntaxException e) {
            System.out.println("Failed to initialise regexp expression " + aPattern);
            e.printStackTrace(System.out);
            System.exit(1);
        }
        return retVal;
    }

    private void log(int aLineNo, String aMsg) {
        this.mMessages.add(new LineText(aLineNo, aMsg));
    }

    private void log(int aLineNo, int aColNo, String aMsg) {
        int colNo = Utils.lengthExpandedTabs(this.mLines[aLineNo - 1], aColNo, this.mConfig.getTabWidth());
        this.mMessages.add(new LineText(aLineNo, colNo + 1, aMsg));
    }

    private void checkVariable(MyVariable aVar, RE aRegexp, String aPattern) {
        if (!aRegexp.match(aVar.getText())) {
            this.log(aVar.getLineNo(), aVar.getColumnNo() - 1, "variable '" + aVar.getText() + "' must match pattern '" + aPattern + "'.");
        }
    }

    private void checkParameter(LineText aParam) {
        if (!this.mConfig.getParamRegexp().match(aParam.getText())) {
            this.log(aParam.getLineNo(), aParam.getColumnNo(), "parameter '" + aParam.getText() + "' must match pattern '" + this.mConfig.getParamPat() + "'.");
        }
    }

    private String[] extractCComment(int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        String[] retVal;
        if (aStartLineNo == aEndLineNo) {
            retVal = new String[]{this.mLines[aStartLineNo - 1].substring(aStartColNo, aEndColNo + 1)};
        } else {
            retVal = new String[aEndLineNo - aStartLineNo + 1];
            retVal[0] = this.mLines[aStartLineNo - 1].substring(aStartColNo);
            int i = aStartLineNo;
            while (i < aEndLineNo) {
                retVal[i - aStartLineNo + 1] = this.mLines[i];
                ++i;
            }
            retVal[retVal.length - 1] = this.mLines[aEndLineNo - 1].substring(0, aEndColNo + 1);
        }
        return retVal;
    }

    private String[] getJavadocBefore(int aLineNo) {
        int lineNo = aLineNo - 1;
        while (lineNo > 0 && this.lineIsBlank(lineNo)) {
            --lineNo;
        }
        return (String[])this.mComments.get(new Integer(lineNo));
    }

    private boolean lineIsBlank(int aLineNo) {
        return "".equals(this.mLines[aLineNo].trim());
    }

    private List getMethodTags(String[] aLines, int aLastLineNo) {
        ArrayList<JavadocTag> tags = new ArrayList<JavadocTag>();
        int currentLine = aLastLineNo - aLines.length;
        int i = 0;
        while (i < aLines.length) {
            ++currentLine;
            if (MATCH_JAVADOC_ARG.match(aLines[i])) {
                tags.add(new JavadocTag(currentLine, MATCH_JAVADOC_ARG.getParen(1), MATCH_JAVADOC_ARG.getParen(2)));
            } else if (MATCH_JAVADOC_NOARG.match(aLines[i])) {
                tags.add(new JavadocTag(currentLine, MATCH_JAVADOC_NOARG.getParen(1)));
            } else if (MATCH_JAVADOC_MULTILINE_START.match(aLines[i])) {
                String p1 = MATCH_JAVADOC_MULTILINE_START.getParen(1);
                String p2 = MATCH_JAVADOC_MULTILINE_START.getParen(2);
                int remIndex = i + 1;
                while (remIndex < aLines.length) {
                    if (MATCH_JAVADOC_MULTILINE_CONT.match(aLines[remIndex])) {
                        remIndex = aLines.length;
                        String lFin = MATCH_JAVADOC_MULTILINE_CONT.getParen(1);
                        if (!lFin.equals(NEXT_TAG) && !lFin.equals(END_JAVADOC)) {
                            tags.add(new JavadocTag(currentLine, p1, p2));
                        }
                    }
                    ++remIndex;
                }
            }
            ++i;
        }
        return tags;
    }

    private void checkParamTags(List aTags, List aParams) {
        ListIterator tagIt = aTags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = (JavadocTag)tagIt.next();
            if (!tag.isParamTag()) continue;
            tagIt.remove();
            boolean found = false;
            ListIterator paramIt = aParams.listIterator();
            while (paramIt.hasNext()) {
                LineText param = (LineText)paramIt.next();
                if (!param.getText().equals(tag.getArg1())) continue;
                found = true;
                paramIt.remove();
                break;
            }
            if (found) continue;
            this.log(tag.getLineNo(), "Unused @param tag for '" + tag.getArg1() + "'.");
        }
        ListIterator paramIt = aParams.listIterator();
        while (paramIt.hasNext()) {
            LineText param = (LineText)paramIt.next();
            this.log(param.getLineNo(), param.getColumnNo(), "Expected @param tag for '" + param.getText() + "'.");
        }
    }

    private void checkReturnTag(List aTags, int aLineNo) {
        boolean found = false;
        ListIterator it = aTags.listIterator();
        while (it.hasNext()) {
            JavadocTag jt = (JavadocTag)it.next();
            if (!jt.isReturnTag()) continue;
            if (found) {
                this.log(jt.getLineNo(), "Duplicate @return tag.");
            }
            found = true;
            it.remove();
        }
        if (!found) {
            this.log(aLineNo, "Expected an @return tag.");
        }
    }

    private void checkThrowsTags(List aTags, List aThrows) {
        HashSet<String> foundThrows = new HashSet<String>();
        ListIterator tagIt = aTags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = (JavadocTag)tagIt.next();
            if (!tag.isThrowsTag()) continue;
            tagIt.remove();
            String documentedEx = tag.getArg1();
            boolean found = foundThrows.contains(documentedEx);
            ListIterator throwIt = aThrows.listIterator();
            while (!found && throwIt.hasNext()) {
                LineText t = (LineText)throwIt.next();
                if (!t.getText().equals(documentedEx)) continue;
                found = true;
                throwIt.remove();
                foundThrows.add(documentedEx);
            }
            if (found) continue;
            boolean reqd = true;
            if (this.mConfig.isCheckUnusedThrows()) {
                ClassResolver cr = new ClassResolver(this.mConfig.getClassLoader(), this.mPkgName, this.mImports);
                try {
                    reqd = !(class$java$lang$RuntimeException == null ? Verifier.class$("java.lang.RuntimeException") : class$java$lang$RuntimeException).isAssignableFrom(cr.resolve(tag.getArg1()));
                }
                catch (ClassNotFoundException e) {
                    this.log(tag.getLineNo(), "Unable to get class information for @throws tag '" + tag.getArg1() + "'.");
                }
            }
            if (!reqd) continue;
            this.log(tag.getLineNo(), "Unused @throws tag for '" + tag.getArg1() + "'.");
        }
        ListIterator throwIt = aThrows.listIterator();
        while (throwIt.hasNext()) {
            LineText t = (LineText)throwIt.next();
            this.log(t.getLineNo(), t.getColumnNo() - 1, "Expected @throws tag for '" + t.getText() + "'.");
        }
    }

    private void checkHeader() {
        if (this.mConfig.getHeaderLines().length > this.mLines.length) {
            this.log(1, "Missing a header - not enough lines in file.");
        } else {
            int i = 0;
            while (i < this.mConfig.getHeaderLines().length) {
                if (!this.mConfig.isHeaderIgnoreLineNo(i + 1)) {
                    String headerLine = this.mConfig.getHeaderLines()[i];
                    try {
                        boolean match;
                        boolean bl = match = this.mConfig.getHeaderLinesRegexp() ? Utils.getRE(headerLine).match(this.mLines[i]) : headerLine.equals(this.mLines[i]);
                        if (!match) {
                            this.log(i + 1, "Line does not match expected header line of '" + this.mConfig.getHeaderLines()[i] + "'.");
                            break;
                        }
                    }
                    catch (RESyntaxException e) {
                        this.log(i + 1, "Unable to parse regular expression '" + headerLine + "'.");
                    }
                }
                ++i;
            }
        }
    }

    private void checkModOrder(MyModifierSet aModSet) {
        MyCommonAST error = aModSet.checkOrderSuggestedByJLS();
        if (error != null) {
            this.log(error.getLineNo(), error.getColumnNo(), "'" + error.getText() + "' modifier out of order with the JLS suggestions.");
        }
    }

    private String basename(String aType) {
        int i = aType.lastIndexOf(".");
        return i == -1 ? aType : aType.substring(i + 1);
    }

    private void checkImports() {
        if (this.mConfig.isIgnoreImports()) {
            return;
        }
        Iterator it = this.mImports.iterator();
        while (it.hasNext()) {
            LineText imp = (LineText)it.next();
            if (Verifier.fromPackage(imp.getText(), "java.lang")) {
                this.log(imp.getLineNo(), "Redundant import from the java.lang package.");
                continue;
            }
            if (Verifier.fromPackage(imp.getText(), this.mPkgName)) {
                this.log(imp.getLineNo(), "Redundant import from the same package.");
                continue;
            }
            if (!imp.getText().endsWith(".*") && !this.mReferenced.contains(this.basename(imp.getText()))) {
                this.log(imp.getLineNo(), "Unused import - " + imp.getText());
                continue;
            }
            if (!this.isIllegalImport(imp.getText())) continue;
            this.log(imp.getLineNo(), "Import from illegal package - " + imp.getText());
        }
    }

    private boolean isIllegalImport(String aImportText) {
        Iterator it = this.mConfig.getIllegalImports().iterator();
        while (it.hasNext()) {
            String illegalPkgName = (String)it.next();
            if (!aImportText.startsWith(illegalPkgName + ".")) continue;
            return true;
        }
        return false;
    }

    private String getIllegalInstantiation(String aClassName) {
        Set illegalInsts = this.mConfig.getIllegalInstantiations();
        String javaLang = "java.lang.";
        if (illegalInsts.contains(aClassName)) {
            return aClassName;
        }
        int clsNameLen = aClassName.length();
        int pkgNameLen = this.mPkgName == null ? 0 : this.mPkgName.length();
        Iterator illIter = illegalInsts.iterator();
        while (illIter.hasNext()) {
            String illegal = (String)illIter.next();
            int illegalLen = illegal.length();
            if (illegalLen - "java.lang.".length() == clsNameLen && illegal.endsWith(aClassName) && illegal.startsWith("java.lang.")) {
                return illegal;
            }
            if (this.mPkgName != null && clsNameLen == illegalLen - pkgNameLen - 1 && illegal.charAt(pkgNameLen) == '.' && illegal.endsWith(aClassName) && illegal.startsWith(this.mPkgName)) {
                return illegal;
            }
            Iterator importIter = this.mImports.iterator();
            while (importIter.hasNext()) {
                LineText importLineText = (LineText)importIter.next();
                String importArg = importLineText.getText();
                if (importArg.endsWith(".*")) {
                    String fqClass = importArg.substring(0, importArg.length() - 1) + aClassName;
                    if (!illegalInsts.contains(fqClass)) continue;
                    return fqClass;
                }
                if (!this.basename(importArg).equals(aClassName) || !illegalInsts.contains(importArg)) continue;
                return importArg;
            }
        }
        return null;
    }

    private boolean inInterfaceBlock() {
        return !this.mInInterface.empty() && Boolean.TRUE.equals(this.mInInterface.peek());
    }

    private boolean inMethodBlock() {
        return this.mMethodBlockLevel > 0;
    }

    private static boolean fromPackage(String aImport, String aPkg) {
        boolean retVal = false;
        if (aPkg == null) {
            retVal = aImport.indexOf(46) == -1;
        } else {
            int index = aImport.lastIndexOf(46);
            if (index != -1) {
                String front = aImport.substring(0, index);
                retVal = front.equals(aPkg);
            }
        }
        return retVal;
    }

    private void checkLCurly(int aStartLine, MyCommonAST aBrace, LeftCurlyOption aOption) {
        int prevLineLen;
        this.verifyWSAroundBegin(aBrace.getLineNo(), aBrace.getColumnNo() + 1, aBrace.getText());
        String braceLine = this.mLines[aBrace.getLineNo() - 1];
        int n = prevLineLen = aBrace.getLineNo() == 1 ? this.mConfig.getMaxLineLength() : Utils.lengthMinusTrailingWhitespace(this.mLines[aBrace.getLineNo() - 2]);
        if (aOption != LeftCurlyOption.IGNORE && (braceLine.length() <= aBrace.getColumnNo() + 1 || braceLine.charAt(aBrace.getColumnNo() + 1) != '}')) {
            if (aOption == LeftCurlyOption.NL) {
                if (!Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine)) {
                    this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "'{' should be on a new line.");
                }
            } else if (aOption == LeftCurlyOption.EOL) {
                if (Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine) && prevLineLen + 2 <= this.mConfig.getMaxLineLength()) {
                    this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "'{' should be on the previous line.");
                }
            } else if (aOption == LeftCurlyOption.NLOW && aStartLine != aBrace.getLineNo()) {
                if (aStartLine + 1 == aBrace.getLineNo()) {
                    if (!Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine)) {
                        this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "'{' should be on a new line.");
                    } else if (prevLineLen + 2 <= this.mConfig.getMaxLineLength()) {
                        this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "'{' should be on the previous line.");
                    }
                } else if (!Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine)) {
                    this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "'{' should be on a new line.");
                }
            }
        }
    }

    void checkWSAfter(int aLineNo, int aColNo, MyToken aConstruct, String aAllow) {
        if (this.mConfig.isIgnoreWhitespace() || MyToken.CAST == aConstruct && this.mConfig.isIgnoreCastWhitespace()) {
            return;
        }
        String line = this.mLines[aLineNo - 1];
        if (aColNo < line.length() && !Character.isWhitespace(line.charAt(aColNo)) && aAllow.indexOf(line.charAt(aColNo)) == -1) {
            this.log(aLineNo, aColNo, aConstruct.getText() + " needs to be followed by whitespace.");
        }
    }

    void checkBlock(String aType, BlockOption aOption, MyCommonAST[] aBraces, boolean aNoStmt) {
        if (aNoStmt && aOption == BlockOption.STMT) {
            this.log(aBraces[0].getLineNo(), aBraces[0].getColumnNo(), "Must have at least one statement.");
        } else if (aOption == BlockOption.TEXT) {
            if (aBraces[0].getLineNo() == aBraces[1].getLineNo()) {
                String txt = this.mLines[aBraces[0].getLineNo() - 1].substring(aBraces[0].getColumnNo() + 1, aBraces[1].getColumnNo());
                if (txt.trim().length() == 0) {
                    this.log(aBraces[0].getLineNo(), aBraces[0].getColumnNo(), "Empty " + aType + " block.");
                }
            } else if (this.mLines[aBraces[0].getLineNo() - 1].substring(aBraces[0].getColumnNo() + 1).trim().length() == 0 && this.mLines[aBraces[1].getLineNo() - 1].substring(0, aBraces[1].getColumnNo()).trim().length() == 0) {
                boolean isBlank = true;
                int i = aBraces[0].getLineNo();
                while (i < aBraces[1].getLineNo() - 1) {
                    if (this.mLines[i].trim().length() > 0) {
                        isBlank = false;
                        break;
                    }
                    ++i;
                }
                if (isBlank) {
                    this.log(aBraces[0].getLineNo(), aBraces[0].getColumnNo(), "Empty " + aType + " block.");
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

