// part of KSUDOKU - by Francesco Rossi <redsh@email.it> 2005
#include "knewdlg.h"
#include <qlayout.h>

#include <kapp.h>
#include <kdialog.h>
#include <kmessagebox.h>
#include "glwindow.h"


KNewDlg::KNewDlg(bool dub2)
 : KDialog()
{
    QGridLayout *top_layout = new QGridLayout(this,3,2,5);
	//top_layout->addColSpacing (20,5);
	//top_layout->addRowSpacing (20,20);
    top_layout->setAutoAdd(true);
	dub = dub2;
	success = 0;
	order = 9;
	difficulty=1;
	
		
	btnsType	   = new QVButtonGroup("Dimensions", this);
	btnsOrder      = new QVButtonGroup("Order", this);
	btnsDifficulty = new QVButtonGroup("Difficulty", this);
	btnsSimmetry   = new QVButtonGroup("Simmetry",this);
	btns           = new QHButtonGroup("", this);
	
	if(!dub)
	{
		rbDifficulty[0] = new QRadioButton("Easy", btnsDifficulty, "easy");
		rbDifficulty[1] = new QRadioButton("Medium", btnsDifficulty, "medium");
		rbDifficulty[1]->setChecked(true);
		rbDifficulty[2] = new QRadioButton("Hard", btnsDifficulty, "hard");
		rbDifficulty[3] = new QRadioButton("Hardest", btnsDifficulty, "hardest");

		rbType[0]		= new QRadioButton("2D    (Sudoku)", btnsType, "2D (Sudoku)");
		rbType[1]		= new QRadioButton("3D!!! (Roxdoku)", btnsType,      "3D!!! (Roxdoku)");
		rbType[0]->setChecked(true);

		rbSimmetry[0] = new QRadioButton("Random", btnsSimmetry, "Random");
		rbSimmetry[1] = new QRadioButton("None", btnsSimmetry, "None");
		rbSimmetry[2] = new QRadioButton("Diagonal", btnsSimmetry, "Diagonal");
		rbSimmetry[3] = new QRadioButton("Central", btnsSimmetry, "Central");
		rbSimmetry[4] = new QRadioButton("4-way", btnsSimmetry, "4-way");
		rbSimmetry[0]->setChecked(true);
	}


	rbOrder[0]      = new QRadioButton("9", btnsOrder, "9");
	rbOrder[0]->setChecked(true);
	rbOrder[1]      = new QRadioButton("16", btnsOrder, "16");
	rbOrder[2]      = new QRadioButton("25", btnsOrder, "25");

	btnsDifficulty->show();
	btnsOrder->show();	
	
	btnOK = new QPushButton(("Generate new puzzle"), btns);
	btnOK->show();
	connect(btnOK, SIGNAL(clicked()), this, SLOT(slotOK()));
  
	btnRIP = new QPushButton(("Rip puzzle"), btns);
	btnRIP->show();
	connect(btnRIP, SIGNAL(clicked()), this, SLOT(slotRIP()));

	btnCancel = new QPushButton(("Cancel"), btns);
	btnCancel->show();
	connect(btnCancel, SIGNAL(clicked()), this, SLOT(slotCancel())); 
	
	
	
	
}

void KNewDlg::slotOK()
{
	success = 1;
	
	for(int i=0; i<4; i++)
		if(rbDifficulty[i]->isChecked())	
			difficulty = 2-i;

	for(int i=0; i<5; i++)
		if(rbSimmetry[i]->isChecked()) simmetry = i;
	
	type = 0;
	if(rbType[1]->isChecked()) type = 1;

			
	if(rbOrder[1]->isChecked())
	{
		order = 16;
		KMessageBox::information(this, "This operation could take a minute.");
	}else if(rbOrder[2]->isChecked())
	{
		order = 25;
		KMessageBox::information(this, "This operation could take a minute.");
	}
	else
		order = 9;
		
	close();
}


void KNewDlg::slotRIP()
{
	type = 0;
	if(rbType[1]->isChecked()) type = 1;
	dub = true;
			
	if(rbOrder[1]->isChecked())
		order = 16;
	else if(rbOrder[2]->isChecked())
		order = 25;
	else
		order = 9;
	success = 2;
	close();
}

void KNewDlg::slotCancel()
{
	success = 0;
	close();
}

KNewDlg::~KNewDlg()
{
	if(!dub)
	{
		delete rbDifficulty[0];
		delete rbDifficulty[1];
		delete rbDifficulty[2];
		delete rbDifficulty[3];
		delete rbSimmetry[0];
		delete rbSimmetry[1];
		delete rbSimmetry[2];
		delete rbSimmetry[3];
		delete rbSimmetry[4];
	}
	delete rbOrder[0];
	delete rbOrder[1];
	delete rbOrder[2];

	delete btnsDifficulty;
	delete btnsOrder;
	delete btnOK;
	delete btnCancel;
	delete btnRIP;
}



