/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _utils_h_
#define _utils_h_

#include <X11/Xutil.h>
#include <Nws/cvt.h>

#if NeedFunctionPrototypes
	extern void X_DrawSimple3DFrame(Display * , Drawable , int , int , int , 
					int , int , Pixel , Pixel );
	extern void X_DrawSimpleRawFrame(Display * , Drawable , int , int , int ,
					int , int , Pixel);
	extern void X_DrawIcon(Display * , Drawable , Icon * , int , int );
	extern void X_Draw3DArrow(Display * , Window , int , int , int , int ,
					int , Pixel , Pixel , Pixel);
	extern void X_Draw3DRectangle(Display * , Drawable , int , int , int ,
					int , int , Pixel , Pixel , Pixel);
	extern void X_Draw3DString(Display * , Drawable , XFontStruct * , int , int ,
					int , String , int , Pixel , Pixel);
	extern void X_DrawTextCursor(Display * , Window , int , int , int , Pixel);
	extern Icon * X_XpmDataToIcon(Display * , char **);
	extern void X_GetWindowRootPosition(Display * , Window , int * , int *);
	extern void Xt_SetInsensitive(Widget);
	extern Widget Xt_GetShell(Widget);
	extern Boolean Xt_IsUp(Widget);
#else
	extern void X_DrawSimple3DFrame();
	extern void X_DrawSimpleRawFrame();
	extern void X_DrawIcon();
	extern void X_Draw3DArrow();
	extern void X_Draw3DRectangle();
	extern void X_Draw3DString();
	extern void X_DrawTextCursor();
	extern Icon * X_XpmDataToIcon();
	extern void X_GetWindowRootPosition();
	extern void Xt_SetInsensitive();
	extern Widget Xt_GetShell();
	extern Boolean Xt_IsUp();
#endif

/* makro na vypocet a alokaciu bledsej farby */
#define LightColor(intensity,fromcolor,tocolor) \
	tocolor.red = (fromcolor.red + intensity) <= 65280 ? \
	fromcolor.red + intensity : 65280 ; \
	tocolor.green = (fromcolor.green + intensity) <= 65280 ? \
	fromcolor.green + intensity : 65280 ; \
	tocolor.blue = (fromcolor.blue + intensity) <= 65280 ? \
	fromcolor.blue + intensity : 65280; \
	if (!XAllocColor(dpy, DefaultColormap(dpy ,DefaultScreen(dpy)),&tocolor)) \
	{ \
		XtWarning("unable to allocate color for border"); \
		tocolor.pixel=WhitePixel(dpy,DefaultScreen(dpy)); \
	}

/* makro na vypocet a alokaciu tmavsej farby */
#define DarkColor(intensity,fromcolor,tocolor) \
	tocolor.red = (fromcolor.red - intensity) <= 0 ? \
	0 : fromcolor.red - intensity  ; \
	tocolor.green = (fromcolor.green - intensity) <= 0 ? \
	0 : fromcolor.green - intensity ; \
	tocolor.blue = (fromcolor.blue - intensity) <= 0 ? \
	0 : fromcolor.blue - intensity ; \
	if (!XAllocColor(dpy, DefaultColormap(dpy ,DefaultScreen(dpy)),&tocolor)) \
	{ \
		XtWarning("unable to allocate color for border"); \
		tocolor.pixel=BlackPixel(dpy,DefaultScreen(dpy)); \
	}


#endif
