#include "forms.h"
#include "string.h"
#include <stdlib.h>
#include <unistd.h>
#include "mikmod.h"
#include "xmikmod.h"
#include "xmikmod.c"

void Mikmod_Play(void);
void Mikmod_Stop(void);
const char *fname;
int quit = 0;
int panning;
int playing = 0;
int interpolation = 0;
int stereo = 1;
int mute = 0;
int paused = 0;
int volume;
UNIMOD *mf;
FD_xmikmod *fd_xmikmod;
FL_OBJECT *br;

char helptext[]=
"Available switches (CaSe SeNsItIvE!):\n"
"\n"
"  -d x    use device-driver #x for output (0 is autodetect). Default=0\n"
"  -ld     List all available device-drivers\n"
"  -ll     List all available loaders\n"
"  -x      disables protracker extended speed\n"
"  -p      disables panning effects (9fingers.mod)\n"
"  -v xx   Sets volume from 0 (silence) to 100. Default=100\n"
"  -f xxxx Sets mixing frequency. Default=44100\n"
"  -m      Force mono output (so sb-pro can mix at 44100)\n"
"  -8      Force 8 bit output\n"
"  -i      Use interpolated mixing\n"
"  -r      Restart a module when it's done playing";

/* callbacks for form xmikmod */
void mikmod_next(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
	 MP_NextPosition();
}

void mikmod_repeat(FL_OBJECT *ob, long data)
{
  mp_loop = !mp_loop;
}

void mikmod_reset(FL_OBJECT *ob, long data)
{
  int counter;
  int storer;
  char str[30];
  storer = mp_sngpos;
  MP_Init(mf);
  mp_sngpos = storer;
  sprintf(str,"%f",fl_get_slider_value(fd_xmikmod->frm_volume));
  volume = atoi(str);
  MP_SetVol(volume);
  mute = 0;
  fl_set_button(fd_xmikmod->frm_mute,mute);
  fl_set_button(fd_xmikmod->frm_reset,0);
}

void mikmod_load(FL_OBJECT *ob, long data)
{
   if (playing)
   {
      Mikmod_Stop();
   }
   else
   {
      fl_set_button(fd_xmikmod->frm_load,0);
      fname = fl_show_file_selector("Select a file to load:","","*","");
      if (fname == NULL) return;
      mf=ML_LoadFN(fname);
      if (mf != NULL)
         Mikmod_Play();
   }
}

void mikmod_loadagain()
{      
   fl_set_button(fd_xmikmod->frm_load,0);
   fname = fl_show_file_selector("File To Load","","*","");
   if (fname == NULL) return;
   mf=ML_LoadFN(fname);
   if (mf != NULL)
      Mikmod_Play();
}

void Mikmod_Stop(void)
{
   playing = 0;
}   


void Mikmod_Play(void)
{
   char strings[15];
    
   if (mf!=NULL)
   {
      playing = 1;
      MP_Init(mf);
      fl_set_object_label(fd_xmikmod->frm_filename,fname);
      fl_set_object_label(fd_xmikmod->frm_songname,mf->songname);
      fl_set_object_label(fd_xmikmod->frm_modtype,mf->modtype);
      fl_set_object_label(fd_xmikmod->frm_periods,mf->flags&UF_XMPERIODS ? "XM type" : "mod type");
      md_numchn=mf->numchn;
      MD_PlayStart();
  	while(!MP_Ready()&&(playing)){
		MD_Update();
		sprintf(strings,"%d",mp_bpm);
		fl_set_object_label(fd_xmikmod->frm_bpm,strings);
		sprintf(strings,"%d",mp_sngpos);
		fl_set_object_label(fd_xmikmod->frm_songpos,strings);
		sprintf(strings,"%d",mp_patpos);
		fl_set_object_label(fd_xmikmod->frm_patternpos,strings);
		sprintf(strings,"%d",mp_sngspd);
		fl_set_object_label(fd_xmikmod->frm_speed,strings);
	}
      MD_PlayStop();          /* stop playing */
      ML_Free(mf);            /* and free the module */
      fl_set_object_label(fd_xmikmod->frm_filename," ");
      fl_set_object_label(fd_xmikmod->frm_songname," ");
      fl_set_object_label(fd_xmikmod->frm_modtype," ");
      fl_set_object_label(fd_xmikmod->frm_periods," ");
      fl_set_object_label(fd_xmikmod->frm_bpm," ");
      fl_set_object_label(fd_xmikmod->frm_songpos," ");
      fl_set_object_label(fd_xmikmod->frm_patternpos," ");
      fl_set_object_label(fd_xmikmod->frm_speed," ");
      if ((!playing)&&(!quit))
         mikmod_loadagain();
   }
}

void mikmod_previous(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
	 MP_PrevPosition();
}

void mikmod_volume(FL_OBJECT *ob, long data)
{
   char str[30];
  /* fill-in code for callback */
   sprintf(str,"%f",fl_get_slider_value(fd_xmikmod->frm_volume));
   volume = atoi(str);
   MP_SetVol(volume);
   mute = 0;
   fl_set_button(fd_xmikmod->frm_mute,mute);
}

void mikmod_panning(FL_OBJECT *ob, long data)
{
   
 /* fill-in code for callback */
   if (panning == 1)
   	panning = 0;
   else
	panning = 1;
   MP_Pan(panning);
}

void mikmod_stereo(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  if (stereo)
  {
     stereo = 0;
  }
  else
  {
     stereo = 1;
  }
}

void mikmod_interpolation(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  if (!interpolation)
  {
     md_mode|=DMODE_INTERP;
     interpolation = 1;
  }
  else
  {
     md_mode&=~DMODE_INTERP;
     interpolation = 0;
  }  
  VC_ReInit();
  }

void mikmod_reverse(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  if (reverse)
     reverse = 0;
  else
     reverse = 1;
  fl_set_button(fd_xmikmod->frm_reverse,reverse);
}
void mikmod_mute(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
   if (mute == 1)
	mute = 0;
   else
	mute = 1;
   MP_Mute(mute);
}

void mikmod_paused(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
   if (paused)
      paused = 0;
   else
      paused = 1;
}


/* callbacks for form xmikmod */
void mikmod_exit(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
   Mikmod_Stop();
   quit = 1;  
}

void tickhandler(void)
{
	FL_OBJECT *xquit;
	if (!paused)
	   MP_HandleTick();    /* play 1 tick of the module */
	MD_SetBPM(mp_bpm);
	xquit = fl_check_forms();
}


int main(int nargc, char *nargv[])
{
   
	FL_OBJECT *xquit;  
	int cmderr=0;                   /* error in commandline flag */
	int morehelp=0;                 /* set if user wants more help */
	int t;
	int counter;
	char strings[15];

        md_mode         =DMODE_16BITS|DMODE_STEREO; /* standard mixing mode */
	md_mixfreq      =44100;                     /* standard mixing freq */
	md_dmabufsize   =10000;                     /* standard dma buf size */
	md_device       =0;
	reverse = 0;          

   fl_initialize(&nargc, nargv, 0, 0, 0);
   fd_xmikmod = create_form_xmikmod();

   /* fill-in form initialization code */

   /* show the first form */
   fl_set_slider_bounds(fd_xmikmod->frm_volume,-50,50);
   fl_show_form(fd_xmikmod->xmikmod,FL_PLACE_CENTER,FL_FULLBORDER,"xMikMod");


                                           /* standard device: autodetect */

	/*
		Register the loaders we want to use..
	*/

	ML_RegisterLoader(&load_m15);    /* if you use m15load, register it as first! */
	ML_RegisterLoader(&load_mod);
	ML_RegisterLoader(&load_mtm);
	ML_RegisterLoader(&load_s3m);
	ML_RegisterLoader(&load_stm);
	ML_RegisterLoader(&load_ult);
	ML_RegisterLoader(&load_uni);
	ML_RegisterLoader(&load_xm);

	/*
		Register the drivers we want to use:
	*/

	MD_RegisterDriver(&drv_nos);

#ifdef __alpha
	MD_RegisterDriver(&drv_af);
#elif defined(__sun__)
	MD_RegisterDriver(&drv_sun);
#else
	MD_RegisterDriver(&drv_vox);
#endif

	MD_RegisterPlayer(tickhandler);


  	opterr=0;

	while( !cmderr &&
		  (t=getopt(nargc,nargv,"ohxpm8irv:f:l:d:")) != EOF ){

		switch(t){

			case 'd':
				md_device=atoi(optarg);
				break;

			case 'l':
				if(optarg[0]=='d') MD_InfoDriver();
				else if(optarg[0]=='l') ML_InfoLoader();
				else{
					cmderr=1;
					break;
				}
				exit(0);

			case 'r':
				mp_loop=1;
				break;

			case 'm':
				md_mode&=~DMODE_STEREO;
				break;

			case '8':
				md_mode&=~DMODE_16BITS;
				break;

			case 'i':
				md_mode|=DMODE_INTERP;
				break;

			case 'x':
				mp_extspd=0;
				break;

			case 'p':
				mp_panning=0;
				break;

			case 'v':
			{
				if((mp_volume=atoi(optarg))>100) mp_volume=100;
				stereo = 0;
				break;
			}

			case 'f':
				md_mixfreq=atol(optarg);
				break;

/*			case 'h':
				morehelp=1;
				cmderr=1;
				break;*/

/*			case '?':
				puts("\07Invalid switch or option needs an argument\n");
				cmderr=1;
				break;*/
		}
	}
	panning = mp_panning;
	fl_set_button(fd_xmikmod->frm_stereo,stereo);
	fl_set_button(fd_xmikmod->frm_repeat,mp_loop);
	fl_set_slider_value(fd_xmikmod->frm_volume,80 - mp_volume);
	if(!MD_Init()){
		return 0;
	}
		fl_set_button(fd_xmikmod->frm_panning,panning);
		fl_set_object_lsize(fd_xmikmod->frm_filename,FL_NORMAL_SIZE);
		fl_set_object_lsize(fd_xmikmod->frm_songname,FL_NORMAL_SIZE);
		fl_set_object_lsize(fd_xmikmod->frm_modtype,FL_NORMAL_SIZE);	
		fl_set_object_lsize(fd_xmikmod->frm_periods,FL_NORMAL_SIZE);

/*	printf("Using %s for %d bit %s %s sound at %u Hz\n\n",
			md_driver->Name,
			(md_mode&DMODE_16BITS) ? 16:8,
			(md_mode&DMODE_INTERP) ? "interpolated":"normal",
			(md_mode&DMODE_STEREO) ? "stereo":"mono",
			md_mixfreq);*/

	quit = 0;
	while (!quit)
	{

		xquit = fl_check_forms();
	}
	MD_Exit();
   return 0;

}
