// -*- C++ -*-
/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor 	 
*	    Copyright (C) 1995 Matthias Ettrich
*
*           This file is Copyleft (C) 1996
*           Lars Gullik Bjnnes
*
*======================================================*/

#ifndef _BUFFER_H_
#define _BUFFER_H_


#include "xdefinitions.h"
#include "lyx_cb.h"
#include "lyxtext.h"
#include "lyxscreen.h"
#include "lyxparameters.h"
#include "lyxrc.h"

class Buffer {
	friend class BufferList;
        void init()
        {
             parameters.Copy(lyxrc.parameters);
        }
public:
	LyXTextParameters parameters;
	LyXText *text;
	LyXScreen *screen;
	char* filename;
	char* tmppath; //where the temporaries go if we want them
	char* buffername;
	char* filepath;
	bool lyx_current;  // is save needed
	bool bak_current;  // is auto save needed
	bool dvi_current;  // do we need to run LaTeX
	char save;         // what is this used for?
	bool read_only;     // buffer is r/o 
	bool allowAccents; // do we allow accents on all chars in this buffer
	const char*GetLanguage() {
		return (const char*)parameters.language;
	}
	Buffer() {
		filename = NULL;
		buffername = NULL;
		tmppath = NULL;
		filepath = NULL;
		text = NULL;
		screen = NULL;
		lyx_current = false;
		bak_current = false;
		dvi_current = false;
		allowAccents = false;
		read_only = false;
		parameters.paragraph = NULL;
		// parameters.Copy(lyxrc.parameters);
	}
	~Buffer(){
		// here the buffer should take care that it is
		// saved properly, before it goes into the void.
		delete text;
		delete screen;
		delete filename;
		delete tmppath;
	}
};

extern void Update(signed char);
extern void BeforeChange();

class BufferList {
private:
#ifdef buffer_as_list
	List *node;
	struct node {
		node *next;
		Buffer *element;
		node() {
			next = NULL;
			element = NULL;
		}
	};
#else
        //const int NUMBER_OF_BUFFERS = 50; //Sun's CC does not like that
        enum{ NUMBER_OF_BUFFERS = 50 };
        Buffer *buffer[NUMBER_OF_BUFFERS];
        int current_buffer;
        int old_current_buffer;
#endif
public:
 	BufferList();
	~BufferList();
	bool isEmpty();
        Buffer* current();
	void write(Buffer *);
	void QwriteAll();
	void closeAll();
	void resize();
	void readFile(const char*, bool);
	void newFile(const char*, const char*);
	void makePup(int);
	void switchBuffer(int);
	void updateInset(Inset*);
	void emergencyWriteAll();
	void close(); // closes current buffer
	void prev();
	bool exists(const char *); // returns true if the buffer exists already
        
        // Open and lock an updatable inset
        void open_new_inset(UpdatableInset* new_inset)
        {
	   BeforeChange();
	   current()->text->InsertInset(new_inset);
	   new_inset->Edit(0,0);
	   Update(1);
	}

};


extern BufferList bufferlist;

#endif
