// -*- C++ -*-
/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
* 	 
*	    Copyright (C) 1995 Matthias Ettrich
*
*======================================================*/
#ifndef _FILE_H
#define _FILE_H

#include "inset.h"
#include "layout.h"
#include "config.h"
#include "lyxtext.h"

enum { NO_LOGFILE=-1, NO_OUPUT, RUN_OK };

typedef struct TeXErrors{
  int status;
  int number_of_errors;
  TeXErrors() {
	  status = NO_LOGFILE;
	  number_of_errors = 0;
  }
};

/* temporary stuff for development */

/* opens only lyx-files */
int OpenFile(const char *filename);

/* opens all files */
int OpenAllFile(const char *filename);

void CloseFile();

char IsLyXFilename(const char* filename);

char IsSGMLFilename(const char* filename);

/* scans the latex-logfile and inserts error insets */
void ScanLogFile(const char*, LyXText*, TeXErrors*);

#endif
