// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 * 	 
 *	  Copyright (C) 1995, 1996 Matthias Ettrich
 *
 *======================================================*/
#ifndef _TABLE_H
#define _TABLE_H
#include <stdio.h>
#include "definitions.h"

/* The features the text class offers for tables */ 


#define LYX_TABLE_APPEND_ROW 0
#define LYX_TABLE_APPEND_COLUMN 1
#define LYX_TABLE_DELETE_ROW 2
#define LYX_TABLE_DELETE_COLUMN 3
#define LYX_TABLE_TOGGLE_LINE_TOP 4
#define LYX_TABLE_TOGGLE_LINE_BOTTOM 5
#define LYX_TABLE_TOGGLE_LINE_LEFT 6
#define LYX_TABLE_TOGGLE_LINE_RIGHT 7
#define LYX_TABLE_ALIGN_LEFT 8
#define LYX_TABLE_ALIGN_RIGHT 9
#define LYX_TABLE_ALIGN_CENTER 10
#define LYX_TABLE_DELETE_TABLE 11
#define LYX_TABLE_MULTICOLUMN 12


#define LYX_TABLE_CELL_NORMAL 0
#define LYX_TABLE_CELL_BEGIN_OF_MULTICOLUMN 1
#define LYX_TABLE_CELL_PART_OF_MULTICOLUMN 2



class LyXTable  {

 public:
   /* konstruktor */
   LyXTable(int columns_arg, int rows_arg);
   LyXTable(FILE* file);
   
   ~LyXTable();
   
   LyXTable* Clone();

   /* returns 1 if there is a topline, returns 0 if not */ 
   char TopLine(int cell);
   char BottomLine(int cell);
   char LeftLine(int cell);
   char RightLine(int cell);

   char TopAlreadyDrawed(int cell);
   char VeryLastRow(int cell);
   
   int AdditionalHeight(int cell);
   int AdditionalWidth(int cell);
   
   /* returns the maximum over all rows */ 
   int WidthOfColumn(int cell);
   int WidthOfTable();
   
   /* returns 1 if a complete update is necessary, otherwise 0 */ 
   int SetWidthOfCell(int cell, int new_width);
   int SetTopLine(int cell, char line);
   int SetBottomLine(int cell, char line);
   int SetLeftLine(int cell, char line);
   int SetRightLine(int cell, char line);
   int SetAlignment(int cell, char align);

   char GetAlignment(int cell);
   
   int GetWidthOfCell(int cell);
   int GetBeginningOfTextInCell(int cell);

   void AppendRow(int cell);
   void DeleteRow(int cell);
   
   void AppendColumn(int cell);
   void DeleteColumn(int cell);
   
   char IsFirstCell(int cell);
   
   int GetNumberOfCells();
   int AppendCellAfterCell(int append_cell, int question_cell);
   int DeleteCellIfColumnIsDeleted(int cell, int delete_column_cell);
   int NumberOfCellsInRow(int cell);
  void Reinit();

   void Init(int columns_arg, int rows_arg);

   void Write(FILE* file);
   void Read(FILE* file);

  // cell <0 will tex the preamble
  // returns the number of printed newlines
  int TexEndOfCell(FILE* file, int cell);

  char IsMultiColumn(int cell);
  void SetMultiColumn(int cell, int number);
  int UnsetMultiColumn(int cell); // returns number of new cells
   
 private:

  struct cellstruct{
    int width_of_cell;
    char  multicolumn;
    char alignment;
  };

   int rows, columns;
   
   char* alignment;
   char* top_line;
   char* bottom_line;
   char* left_line;
   char* right_line;
   cellstruct** cell_info;

   int* width_of_column;
   
   int width_of_table;
   
   
  // returns true if change
   char calculate_width_of_column(int column);
   void calculate_width_of_table();

   int row_of_cell(int cell);
   int column_of_cell(int cell);
   int right_column_of_cell(int cell);

   cellstruct* cellinfo_of_cell(int cell);

  void delete_column(int column);

  int cells_in_multicolumn(int cell);
   
};

#endif







