%{

typedef struct {
  PyObject_HEAD
  GtkObject *go;
} PyGtk_Object;
PyTypeObject *PyGtk_Type;
#define PyGtk_Check(op) ((op)->ob_type == PyGtk_Type)

static PyObject *
PyGtk_New(GtkObject *go) {
  PyGtk_Object *self;

  self = (PyGtk_Object *)PyObject_NEW(PyGtk_Object, PyGtk_Type);
  if (self == NULL)
    return NULL;
  self->go = go;
  gtk_object_ref(self->go);
  return (PyObject *)self;
}

static PyObject * gdk__imlib_init(PyObject *self, PyObject *args) {
  static called = 0;
  PyObject *gtk_mod, *dict, *func, *types;

  if (called) {
    Py_INCREF(Py_None);
    return Py_None;
  }
  called = 1;
  if (!PyArg_ParseTuple(args, ":gdk_imlib_init"))
    return NULL;

  
  gtk_mod = PyImport_ImportModule("gtk");
  dict = PyModule_GetDict(gtk_mod);
  Py_DECREF(gtk_mod);
  /* make sure gtk_init was called */
  func = PyDict_GetItemString(dict, "gtk_init");
  types = PyObject_CallObject(func, NULL);
  Py_DECREF(types);

  func = PyDict_GetItemString(dict, "_get_types");
  types = PyObject_CallObject(func, NULL);

  /* actually get the GtkObject python type, so it can be used in this mod */
  PyGtk_Type = (PyTypeObject *)PyDict_GetItemString(types, "GtkObject");
  Py_INCREF(PyGtk_Type);
  Py_DECREF(types);

  /* now actually initialise imlib */
  gdk_imlib_init();

  Py_INCREF(Py_None);
  return Py_None;
}

%}

%native(gdk_imlib_init) PyObject *gdk__imlib_init(PyObject *s, PyObject *a);
