/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/kernel/sources/RCS/cc_rcc.ph,v $
  SHORTNAME      : 
  SNNS VERSION   : 4.1

  PURPOSE        : Header file of correspondent '.c' file
  NOTES          :

  AUTHOR         : Michael Schmalzl
  DATE           : 5.2.92

  CHANGED BY     : Michael Schmalzl
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 2.6 $
  LAST CHANGE    : $Date: 1995/11/16 12:02:04 $

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#ifndef _CC_RCC_DEFINED_
#define  _CC_RCC_DEFINED_

/* begin global definition section */

krui_err cc_freeStorage(int StartPattern, int EndPattern, int flag);
void rcc_manageResetArray(int startPattern, int endPattern, int flag);
void rcc_manageLinkArray(int newNoOfSpecialUnits, int flag);
krui_err cc_deleteAllSpecialAndAllHiddenUnits(void);
krui_err cc_allocateStorage(int StartPattern,int EndPattern, int NoOfSpecialUnits);
void cc_initErrorArrays(void);
void cc_initActivationArrays(void);
void cc_printTopoPtrArray(void);
void cc_printUnitArray(void);
FlintType cc_generateRandomNo(float maxValue);
void cc_printUnit(struct Unit *unitPtr);
void cc_printAllLinks(struct Unit *unitPtr);
void cc_compareActFunctions(int actFunc,int flag);
krui_err cc_changeActFuncOfSpecialUnits(int type,int LearnFunc);
krui_err cc_calculateNetParameters(int *maxYPosOfHiddenUnit,int *xPosOfLastInsertedHiddenUnit,
                                   int *yPosOfLastInsertedHiddenUnit,int *outputXMax);
void cc_initOutputUnits(void);
float cc_calculateCorrelation(int StartPattern,int EndPattern,int counter);
void cc_initInputUnitsWithPattern(int PatternNo);
krui_err cc_setHiddenUnit(struct Unit *hiddenUnitPtr,int maxYPosOfHiddenUnit,
                                 int *xPosOfLastInsertedHiddenUnit,int *yPosOfLastInsertedHiddenUnit);
krui_err cc_setPointers(void);
krui_err cc_initSpecialUnitLinks(void);
void cc_updatePosOfSpecialUnits(void);
krui_err cc_deleteAllSpecialUnits(void);   


struct CC_DATA  cc_data ={
  { MAX_PIXEL_ERROR,
    LEARNING_FUNC, 
    ON_OFF, 0, 0, 150, SBC},
  { MIN_COVARIANCE_CHANGE, 
    SPECIAL_PATIENCE,
    MAX_NO_OF_COVARIANCE_UPDATE_CYCLES,
    MAX_SPECIAL_UNIT_NO, 
    SPECIAL_FUNC_TYPE },
  { MIN_ERROR_CHANGE,
    OUT_PATIENCE,
    MAX_NO_OF_ERROR_UPDATE_CYCLES}
};

char *cc_onOffArray[]       ={"off","on"};
char *cc_actFuncArray[]     ={"Act_Logistic","Act_LogSym","Act_TanH",
                              "Act_Random"};
char *cc_learningFuncArray[]={"Quickprop","Backprop","RPROP"};
char *cc_pruningFuncArray[]={"SBC","AIC","CMSEP"};
char *rcc_actFuncArray[]     ={"Act_RCC_Logistic","Act_RCC_LogisticSym","Act_RCC_Tanh",
                               "Act_Random"};

int cc_end=0;
int cc_storageFree=1;

int cc_allButtonIsPressed=1;
int rcc_currentPattern;


struct Unit  **FirstInputUnitPtr,**FirstHiddenUnitPtr,
             **FirstOutputUnitPtr,**FirstSpecialUnitPtr,
              *bestSpecialUnitPtr;

float **OutputUnitError=NULL;
float **SpecialUnitAct=NULL;
float **CorBetweenSpecialActAndOutError=NULL;
float *OutputUnitSumError=NULL;
float *SpecialUnitSumAct=NULL;
int   LastInsertedHiddenUnit;

void (*cc_trainSpecialUnits)(int maxNoOfCovarianceUpdateCycles, float minCovarianceChange, 
                                 int specialPatience,int StartPattern,int EndPattern,
                                 float param4, float param5, float param6, int MaxSpecialUnitNo);
void (*cc_trainOutputUnits)(int maxNoOfErrorUpdateCycles, float minErrorChange, 
                                int outPatience, int StartPattern,int EndPattern,
                                float param1,float param2, float param3,
                                float **ParameterOutArray,int *NoOfOutParams);

int cc_update = 0;
float SumSqError;
int cc_printOnOff;
int cc_backfittingOnOff;
int *reset=0;
float **linkArray=0;
int cc_cascade=0;

/* end global definition section */



/* begin privat definition section */

static int OldNoOfSpecialUnitStorage=0;
static struct {
         int StartPattern;
         int EndPattern;
       } old={0,0};  

/* end privat definition section */

#endif /* _CC_RCC_DEFINED_ */



