/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/tools/sources/RCS/error.c,v $
  SHORTNAME      : error
  SNNS VERSION   : 4.1

  PURPOSE        : Functions to print out error messages and warnings
  NOTES          : 

  AUTHOR         : Jens Wieland
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.2 $
  LAST CHANGE    : $Date: 1995/07/26 09:25:40 $

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/

#include <stdio.h>

#include "symtab.h"
#include "ictab.h"
#include "glob_typ.h"  /* SNNS-Kernel: Global Datatypes and Constants */
#include "error.ph"
#include "batchman.h"  /* for warn_flag, message_flag */
#include "kr_ui.h"     /* SNNS-Kernel: User Interface Function Prototypes */



/*****************************************************************************
  FUNCTION : inc_sourcelines

  PURPOSE  : increments the source line number counter
  RETURNS  : 
  NOTES    :

  UPDATE   : 
******************************************************************************/
void inc_sourcelines(void)
{
  sourceline_no++;
}


/*****************************************************************************
  FUNCTION : get_sourceline

  PURPOSE  : returns the source line number 
  RETURNS  : the source line number
  NOTES    : for errors that do occur during parsing or scanning;
             line number translation is not necessary here
  UPDATE   : 
******************************************************************************/
int get_sourceline(void)
{
  return sourceline_no;
}


/*****************************************************************************
  FUNCTION : chck_type

  PURPOSE  : checks if argument two is of expected type
  RETURNS  : 
  NOTES    :

  UPDATE   : 
******************************************************************************/
void chck_type(Data_type expected, Data_type two)
{
  if (expected != two)
  switch(expected)
  {
    case STRING: err_prt("String argument expected"); break;
    case REAL: err_prt("Real value argument expected"); break;
    case INT: err_prt("Integer value argument expected"); break;
    case BOOL: err_prt("Boolean value argument expected"); break;
    default:;
  }
}


/*****************************************************************************
  FUNCTION : err_prt

  PURPOSE  : prints an error message and exits batchman
  RETURNS  : 
  NOTES    :

  UPDATE   : 
******************************************************************************/
void err_prt(char *text)
{
  fprintf(stderr, "*** Batchman error at line %d:\n    %s\n", 
	  get_xref(), text);
  exit(1);
}


/*****************************************************************************
  FUNCTION : kernel_error

  PURPOSE  : prints SNNS-kernel errors in Batchman error format
  RETURNS  : 
  NOTES    :

  UPDATE   : 
******************************************************************************/
void kernel_error(krui_err err)
{
  if(err != KRERR_NO_ERROR)
  err_prt(krui_error(err));
}


/*****************************************************************************
  FUNCTION : warn_prt

  PURPOSE  : prints a warning
  RETURNS  : 
  NOTES    :

  UPDATE   : 
******************************************************************************/
void warn_prt(char *text)
{
  static int warn_cnt = 0;
  static int no_more_warnings = 0;

  if ((!no_more_warnings) && (!message_flag) && (!warn_flag))
  if (warn_cnt++ < MAX_WARNINGS)  /* do not print too many warnings */
  fprintf(stderr, "-> Batchman warning at line %d:\n   %s\n", 
	  get_xref(), text);
  else 
  {
    fprintf(stderr, "-> Further warnings suppressed.\n");
    no_more_warnings = 1;
  }
}


/*****************************************************************************
  FUNCTION : yyzerror

  PURPOSE  : error reporting routine required by main input parser 
             prints parse errors
  RETURNS  :
  NOTES    :

  UPDATE   : 
******************************************************************************/
void yyzerror(char *text)
{
  if (!message_flag)
  fprintf(stderr, "*** Batchman parser error at line %d:\n    %s\n", 
	  get_sourceline(), text);
  exit(1);
}


/*****************************************************************************
  FUNCTION : yyyerror

  PURPOSE  : error reporting routine required by shell output parser 
             prints parse errors
  RETURNS  : 
  NOTES    :

  UPDATE   : 
******************************************************************************/
void yyyerror(char *text)
{
  yyzerror(text);
}
