(in-package "ACL2")

;this book contains the sticky lemmas from merge4 (all general lemmas from merge4 were moved to merge)

(include-book "merge")
(include-book "stick")

(defthm bvecp-sigm
    (implies (and (natp n)
		  (bvecp a n)
		  (bvecp b n))
	     (bvecp (sigm a b c n) n))
  :rule-classes ()
    :hints (("Goal" :in-theory (enable bvecp)
		    :use (sigm-bnds))))

(defthm bvecp-kap
    (implies (and (natp n)
		  (bvecp a n)
		  (bvecp b n))
	     (bvecp (kap a b n) (1+ n)))
    :rule-classes ()
    :hints (("Goal" :in-theory (enable bvecp)
		    :use (kap-bnds))))

(defthm bvecp-tau
    (implies (and (natp n)
		  (bvecp a n)
		  (bvecp b n))
	     (bvecp (tau a b c n) (1+ n)))
    :rule-classes ()
    :hints (("Goal" :in-theory (enable bvecp)
		    :use (tau-bnds))))

(defthm top-thm-2
    (implies (and (natp n)
		  (bvecp a n)
		  (bvecp b n)
		  (natp k)
		  (< k n)
		  (or (= c 0) (= c 1)))
	     (iff (= (bits (+ a b c) k 0) 0)
		  (= (bits (tau a b c n) k 0) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bvecp)
		  :use (stick-lemma
			bvecp-tau
			(:instance bits-mod (x (+ a b c)) (i k))
			(:instance bits-mod (x (tau a b c n)) (i k))))))


(local-defthm sticky-21-1
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (= (bits (+ (bits x (1- k) 0)
			 (bits y (1- k) 0))
		      (1- k) 0)
		0))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-mod)
		  :use ((:instance mod-mod-sum (a x) (b y) (n (expt 2 k)))))))

(local-defthm sticky-21-2
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (and (<= 0 
		      (+ (bits x (1- k) 0)
			 (bits y (1- k) 0)))
		  (< (+ (bits x (1- k) 0)
			(bits y (1- k) 0))
		     (expt 2 (1+ k)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-mod)
		  :use ((:instance mod-bnd-1 (m x) (n (expt 2 k)))
			(:instance mod-bnd-1 (m y) (n (expt 2 k)))))))

(local-defthm sticky-21-3
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (and (<= 0 
		      (/ (+ (bits x (1- k) 0)
			    (bits y (1- k) 0))
			 (expt 2 k)))
		  (< (/ (+ (bits x (1- k) 0)
			   (bits y (1- k) 0))
			(expt 2 k))
		     2)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable a2 expt-inverse)
		  :use (sticky-21-2))))


(local-defthm sticky-21-4
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (and (<= 0 (fl (/ (+ (bits x (1- k) 0)
				  (bits y (1- k) 0))
			       (expt 2 k))))
		  (< (fl (/ (+ (bits x (1- k) 0)
				  (bits y (1- k) 0))
			    (expt 2 k)))
		     2)))
  :rule-classes ()
  :hints (("Goal" :use (sticky-21-3
			(:instance n<=fl-linear
				   (n 0) 
				   (x (/ (+ (bits x (1- k) 0)
					    (bits y (1- k) 0))
					 (expt 2 k))))
			(:instance fl-def-linear
				   (x (/ (+ (bits x (1- k) 0)
					    (bits y (1- k) 0))
					 (expt 2 k))))))))

(local-defthm sticky-21-5
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (member (fl (/ (+ (bits x (1- k) 0)
			       (bits y (1- k) 0))
			    (expt 2 k)))
		     '(0 1)))
  :rule-classes ()
  :hints (("Goal" :use (sticky-21-4))))

(local-defthm sticky-21-6
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (member (+ (bits x (1- k) 0)
			(bits y (1- k) 0))
		     (list (expt 2 k) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-mod)
		  :use (sticky-21-5
			sticky-21-1
			(:instance quot-mod
				   (m (+ (bits x (1- k) 0)
					 (bits y (1- k) 0)))
				   (n (expt 2 k)))))))

(local-defthm hack-6
    (implies (and (natp k)
		  (>= k 2))
	     (natp (expt 2 (- k 2))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp))))

(local-defthm sticky-21-7
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (>= k 2)
		  (= (bits (+ x y) (1- k) 0) 0)
		  (= (bitn x (1- k)) 0)
		  (= (bitn y (1- k)) 0))
	     (equal (+ (bits x (1- k) 0)
		       (bits y (1- k) 0))
		    0))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp bits-mod)
		  :use (sticky-21-6
			hack-6
			(:instance bits-plus-bitn (n (1- k)) (m 0))
			(:instance bits-plus-bitn (x y) (n (1- k)) (m 0))
			(:instance mod-bnd-1 (m x) (n (expt 2 (1- k))))
			(:instance mod-bnd-1 (m y) (n (expt 2 (1- k))))))))

(local-defthm hack-7
    (implies (and (natp k)
		  (>= k 2))
	     (> (expt 2 (- k 2)) 0))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp))))

(local-defthm hack-8
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (>= k 2))
	     (not (EQUAL (+ (* 2 (EXPT 2 (+ -2 K)))
			    (+ (BITS Y (+ -2 K) 0)
			       (* 2 (EXPT 2 (+ -2 K))
				  (BITN Y (+ -1 K))))
			    (BITS X (+ -2 K) 0))
			 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp)
		  :use (hack-7 (:instance bitn-0-1 (x y) (n (1- k)))
			))))

(local-defthm hack-9
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (>= k 2))
	     (not (EQUAL (+ (BITS X (+ -1 K) 0)
			    (* 2 (EXPT 2 (+ -2 K)))
			    (BITS Y (+ -2 K) 0))
			 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp)
		  :use (hack-7
			(:instance bitn-0-1 (x y) (n (1- k)))))))

(local-defthm sticky-21-8-2
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (>= k 2)
		  (= (bits (+ x y) (1- k) 0) 0)
		  (or (= (bitn x (1- k)) 1)
		      (= (bitn y (1- k)) 1)))
	     (equal (+ (bits x (1- k) 0)
		       (bits y (1- k) 0))
		    (expt 2 k)))
  :rule-classes ()
  :hints (("Goal" :use (sticky-21-6
			hack-8
			hack-9
			(:instance bits-plus-bitn (n (1- k)) (m 0))
			(:instance bits-plus-bitn (x y) (n (1- k)) (m 0))))))
(local-defthm bitn+0
    (implies (and (natp x)
		  (natp y))
	     (= (bitn (+ x y) 0)
		(bitn (+ (bitn x 0) (bitn y 0)) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bitn-rec-0)
		  :use ((:instance mod-sum (a (bitn x 0)) (b y) (n 2))
			(:instance mod-sum (a y) (b x) (n 2))))))

(local-defthm sticky-21-8-1
    (implies (and (natp x)
		  (natp y)
		  (= (bits (+ x y) 0 0) 0)
		  (or (= (bitn x 0) 1)
		      (= (bitn y 0) 1)))
	     (equal (+ (bits x 0 0)
		       (bits y 0 0))
		    2))
    :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-n-n-rewrite
                                     )
		  :use (bitn+0
			(:instance bitn-0-1 (n 0))
			(:instance bitn-0-1 (x y) (n 0))))))

(local-defthm sticky-21-8
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0)
		  (or (= (bitn x (1- k)) 1)
		      (= (bitn y (1- k)) 1)))
	     (equal (+ (bits x (1- k) 0)
		       (bits y (1- k) 0))
		    (expt 2 k)))
  :rule-classes ()
  :hints (("Goal" :use (sticky-21-8-2
			sticky-21-8-1))))

(local-defthm sticky-21-9
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (equal (+ (bits x (1- k) 0)
		       (bits y (1- k) 0))
		    (* (expt 2 k)
		       (logior (bitn y (1- k))
			       (bitn x (1- k))))))
  :rule-classes ()
  :hints (("Goal" :use (sticky-21-7
			sticky-21-8
			(:instance bitn-0-1 (n (1- k)))
			(:instance bitn-0-1 (x y) (n (1- k)))))))

(local (in-theory (disable BITS-PLUS-BITN-REWRITE)))

(local (in-theory (enable bits-mod)))
(local-defthm sticky-21-10
    (implies (and (natp x)
		  (natp y)

		  (natp k)
		  (> k 0)
		  (natp n)
		  (>= n k)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (equal (* (expt 2 k) (bits (+ x y) n k))
		    (bits (+ (bits x n 0) (bits y n 0))
			  n 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable mod-sum bits-mod)
		  :use ((:instance bits-plus-bits (x (+ x y)) (m (1+ n)) (n k) (r 0))
			(:instance mod-mod-sum (a x) (b y) (n (expt 2 k)))))))

(local-defthm sticky-21-11
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (natp n)
		  (>= n k)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (equal (* (expt 2 k) (bits (+ x y) n k))
		    (bits (* (expt 2 k)
			     (+ (bits x n k) (bits y n k) (logior (bitn x (1- k)) (bitn y (1- k)))))
			  n 0)))
  :rule-classes ()
  :hints (("Goal" :use (sticky-21-10
			sticky-21-9
			(:instance bits-plus-bits (m (1+ n)) (n k) (r 0))
			(:instance bits-plus-bits (x y) (m (1+ n)) (n k) (r 0))))))

(local-defthm sticky-21-12
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (natp n)
		  (>= n k)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (equal (* (expt 2 k) (bits (+ x y) n k))
		    (* (expt 2 k)
		       (bits (+ (bits x n k) (bits y n k) (logior (bitn x (1- k)) (bitn y (1- k))))
			     (- n k) 0))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp)
		  :use (sticky-21-11
			(:instance bits-shift-5
				   (x (+ (bits x n k) (bits y n k) (logior (bitn x (1- k)) (bitn y (1- k)))))
				   (i (- n k)))))))

(local-defthm sticky-21
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (natp n)
		  (>= n k)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (equal (bits (+ x y) n k)
		    (bits (+ (bits x n k) (bits y n k) (logior (bitn x (1- k)) (bitn y (1- k))))
			  (- n k) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp)
		  :use (sticky-21-12
			(:instance cancel-equal-*
				   (a (expt 2 k))
				   (r (bits (+ x y) n k))
				   (s (bits (+ (bits x n k) (bits y n k) (logior (bitn x (1- k)) (bitn y (1- k))))
					    (- n k) 0)))))))
;counts as a sticky lemma?
(defthm bits-sum-0
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0)
		  (= (bits (+ x y) (1- j) 0) 0))
	     (equal (bits (+ x y) i j)
		    (bits (+ (bits x i j) (bits y i j) (logior (bitn x (1- j)) (bitn y (1- j))))
			  (- i j) 0)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance sticky-21 (n i) (k j))))))



(local-defthm bits-sum-1
    (implies (and (natp x)
		  (natp y)
		  (natp j)
		  (> j 0))
	     (equal (BITS (+ (BITS X (+ -1 J) 0)
			     (BITS Y (+ -1 J) 0))
			  J 0)
		    (+ (BITS X (+ -1 J) 0)
		       (BITS Y (+ -1 J) 0))))
  :hints (("Goal" :in-theory (union-theories (disable bits-bvecp) '(natp bvecp))
		  :use ((:instance bits-bvecp (i (1- j)) (j 0) (n j))
			(:instance bits-bvecp (x y) (i (1- j)) (j 0) (n j))
			(:instance bits-tail (x (+ (BITS X (+ -1 J) 0) (BITS Y (+ -1 J) 0))) (n j))))))

(local (in-theory (disable bits-mod)))

(local-defthm bits-sum-2
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0))
	     (equal (+ (bits x i 0)
		       (bits y i 0))
		    (+ (* (expt 2 j)
			  (+ (bits x i j)
			     (bits y i j)
			     (bitn (+ (bits x (1- j) 0)
				      (bits y (1- j) 0))
				   j)))
		       (bits (+ (bits x (1- j) 0)
				(bits y (1- j) 0))
			     (1- j)
			     0))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bits-plus-bits (m (1+ i)) (n j) (r 0))
			(:instance bits-plus-bits (x y) (m (1+ i)) (n j) (r 0))
			(:instance bits-plus-bitn (x (+ (bits x (1- j) 0) (bits y (1- j) 0))) (n j) (m 0))))))

(local-defthm bits-sum-3
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0))
	     (equal (mod (+ (bits x i 0)
			    (bits y i 0))
			 (expt 2 (1+ i)))
		    (mod (+ x y)
			 (expt 2 (1+ i)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable mod-sum bits-mod)
		  :use ((:instance mod-sum (a (bits x i 0)) (b y) (n (expt 2 (1+ i))))
			(:instance mod-sum (a x) (b y) (n (expt 2 (1+ i))))))))

(local-defthm bits-sum-4
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0))
	     (equal (bits (+ x y) i j)
		    (bits (+ (bits x i 0)
			     (bits y i 0))
			  i j)))
  :rule-classes ()
  :hints (("Goal" :use (bits-sum-3
			(:instance mod-bits-equal (x (+ x y)) (y (+ (bits x i 0) (bits y i 0))))))))

(local-defthm bits-sum-5
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0))
	     (equal (bits (+ x y) i j)
		    (bits (+ (* (expt 2 j)
				(+ (bits x i j)
				   (bits y i j)
				   (bitn (+ (bits x (1- j) 0)
					    (bits y (1- j) 0))
					 j)))
			     (bits (+ (bits x (1- j) 0)
				      (bits y (1- j) 0))
				   (1- j)
				   0))
			  i j)))
  :rule-classes ()
  :hints (("Goal" :use (bits-sum-4 bits-sum-2))))

(local-defthm bits-sum-6
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0))
	     (< (bits (+ (bits x (1- j) 0)
			 (bits y (1- j) 0))
		      (1- j)
		      0)
		(expt 2 j)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-mod)
		  :use ((:instance mod-bnd-1 (m (+ (bits x (1- j) 0) (bits y (1- j) 0))) (n (expt 2 j)))))))

(defthm bits-sum
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0))
	     (equal (bits (+ x y) i j)
		    (bits (+ (bits x i j)
			     (bits y i j)
			     (bitn (+ (bits x (1- j) 0)
				      (bits y (1- j) 0))
				   j))
			  (- i j) 0)))
  :rule-classes ()
  :hints (("Goal" :use (bits-sum-5 
			bits-sum-6
			(:instance bits-plus-mult
				   (x (bits (+ (bits x (1- j) 0)
					       (bits y (1- j) 0))
					    (1- j)
					    0))
				   (y (+ (bits x i j)
					 (bits y i j)
					 (bitn (+ (bits x (1- j) 0)
						  (bits y (1- j) 0))
					       j)))
				   (k j)
				   (n i)
				   (m j))))))

(local-defthm stick-lemma-3-1
    (implies (and (natp a)
		  (natp b)
		  (natp k))
	     (equal (bits (+ a b 1) k 0)
		    (bits (+ (bits a k 0)
			     (bits b k 0)
			     1)
			  k 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-mod)
		  :use ((:instance mod-sum (a (1+ (bits a k 0))) (n (expt 2 (1+ k))))
			(:instance mod-sum (a (1+ b)) (b a) (n (expt 2 (1+ k))))))))

(local (in-theory (disable comp1)))

(local (in-theory (disable bits-tail bits-reduce)))

(local-defthm stick-lemma-3-2
    (implies (and (natp n)
		  (natp k)
		  (natp j)
		  (< k n)
		  (<= j k)
		  (bvecp a n)
		  (bvecp b n))
	     (equal (bits (comp1 (logxor a b) n) k j)
		    (comp1 (logxor (bits a k j) (bits b k j)) (1+ (- k j)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-comp1 bits-logxor logxor-bvecp natp))))

(local-defthm stick-lemma-3-3
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (bvecp a n)
		  (bvecp b n))
	     (equal (bitn (comp1 (logxor a b) n) k)
		    (comp1 (logxor (bitn a k) (bitn b k)) 1)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-n-n-rewrite logxor-bvecp comp1-bvecp)
		  :use ((:instance stick-lemma-3-2 (j k))))))

(local-defthm stick-lemma-3-4
    (implies (and (natp n)
		  (> n 0)
		  (bvecp a n)
		  (bvecp b n))
	     (equal (bits (+ a b 1) 0 0)
		    (bits (comp1 (logxor a b) n) 0 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-n-n-rewrite logxor-bvecp comp1-bvecp)
		  :use ((:instance stick-lemma-3-1 (k 0))
			(:instance stick-lemma-3-2 (k 0) (j 0))
			(:instance bitn-0-1 (x a) (n 0))
			(:instance bitn-0-1 (x b) (n 0))))))

(local-defthm stick-lemma-3-5
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (iff (equal (bits (+ a b 1) (1- k) 0)
			      0)
		       (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			      0))
		  (not (equal (bits (+ a b 1) (1- k) 0) 0)))
	     (iff (equal (bits (+ a b 1) k 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) k 0)
			 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable logxor-bvecp comp1-bvecp)
		  :use ((:instance bits-plus-bitn
				   (x (comp1 (logxor a b) n))
				   (n k)
				   (m 0))
			(:instance bits-plus-bitn
				   (x (+ a b 1))
				   (n k)
				   (m 0))
			(:instance bits-0-bitn-0
				   (x (comp1 (logxor a b) n))
				   (n k))
			(:instance bits-0-bitn-0
				   (x (+ a b 0))
				   (n k))))))


(local-defthm stick-lemma-3-6
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (< (+ (bits a (1- k) 0) (bits b (1- k) 0) 1)
		(* 2 (expt 2 k))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bvecp<= (x (bits a (1- k) 0)) (n k))
			(:instance bvecp<= (x (bits b (1- k) 0)) (n k))))))

(local-defthm stick-lemma-3-7
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (= (+ (bits a (1- k) 0) (bits b (1- k) 0) 1)
		(expt 2 k)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-mod)
		  :use (stick-lemma-3-6
			(:instance stick-lemma-3-1 (k (1- k)))
			(:instance mod-must-be-n
				   (m (+ (bits a (1- k) 0) (bits b (1- k) 0) 1))
				   (n (expt 2 k)))))))



(local-defthm stick-lemma-3-8
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (= (bits (+ a b 1) k 0)
		(bits (* (expt 2 k) (+ (bitn a k) (bitn b k) 1)) k 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable BITS-PLUS-BITN-REWRITE)
           :use (stick-lemma-3-7
                 stick-lemma-3-1))))

(local-defthm stick-lemma-3-9
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (= (bits (+ a b 1) k 0)
		(* (expt 2 k) 
		   (bits (+ (bitn a k) (bitn b k) 1) 0 0))))
  :rule-classes ()
  :hints (("Goal" :use (stick-lemma-3-8
			(:instance bits-shift-5 (x (+ (bitn a k) (bitn b k) 1)) (i 0))))))

(local-defthm stick-lemma-3-10
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (iff (= (bits (+ a b 1) k 0) 0)
		  (= (bits (+ (bitn a k) (bitn b k) 1) 0 0) 0)))
  :rule-classes ()
  :hints (("Goal" :use (stick-lemma-3-9))))

(local-defthm stick-lemma-3-11
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (iff (= (bits (+ a b 1) k 0) 0)
		  (= (comp1 (logxor (bits a k k) (bits b k k)) 1) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-n-n-rewrite)
		  :use (stick-lemma-3-10
			(:instance bitn-0-1 (x a) (n k))
			(:instance bitn-0-1 (x b) (n k))))))

(local-defthm stick-lemma-3-12
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (iff (= (bits (+ a b 1) k 0) 0)
		  (= (bits (comp1 (logxor a b) n) k k) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-comp1 comp1-logxor bitn-comp1 bits-logxor comp1-bvecp logxor-bvecp bitn-logxor)
		  :use (stick-lemma-3-11))))



(local-defthm stick-lemma-3-13
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (iff (= (bits (+ a b 1) k 0) 0)
		  (= (bits (comp1 (logxor a b) n) k 0) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bitn-logxor bitn-comp1 bits-n-n-rewrite bits-comp1 bits-logxor comp1-bvecp logxor-bvecp)
		  :use (stick-lemma-3-12
			(:instance bits-0-bitn-0
				   (x (comp1 (logxor a b) n))
				   (n k))))))

(local-defthm stick-lemma-3-14
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (iff (equal (bits (+ a b 1) (1- k) 0)
			      0)
		       (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			      0)))
	     (iff (equal (bits (+ a b 1) k 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) k 0)
			 0)))
  :rule-classes ()
  :hints (("Goal" :use (stick-lemma-3-5
			stick-lemma-3-13))))


(defthm top-thm-1
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (bvecp a n)
		  (bvecp b n))
	     (iff (= (bits (+ a b 1) k 0)
		     0)
		  (= (bits (comp1 (logxor a b) n) k 0)
		     0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bitn-logxor)
           :induct (natp-induct k))
	  ("Subgoal *1/2" :use stick-lemma-3-14)
	  ("Subgoal *1/1" :use stick-lemma-3-4)))
