; See the comment in init.lsp.

(in-package 'compiler)

(defun inline-type-matches (inline-info arg-types return-type
                                        &aux (rts nil))
  (if (not (typep (third inline-info) 'fixnum))
      (fix-opt inline-info))
  (if (member 'integer(car inline-info)) (return-from inline-type-matches nil))
  (if (and (let ((types (car inline-info)))
                (declare (object types))
                (dolist** (arg-type arg-types (or (equal types '(*))
						  (endp types)))
	                (when (endp types) (return nil))
		  (cond ((equal types '(*))
			 (setq types '(t *))))
                  (cond ((eq (car types) 'fixnum-float)
                         (cond ((type>= 'fixnum arg-type)
                                (push 'fixnum rts))
                               ((type>= 'long-float arg-type)
                                (push 'long-float rts))
                               ((type>= 'short-float arg-type)
                                (push 'short-float rts))
                               (t (return nil))))
                        ((type>= (car types) arg-type)
                         (push (car types) rts))
                        (t (return nil)))
                  (pop types)))
	   (type>= (cadr inline-info) return-type))
       (cons (reverse rts) (cdr inline-info))
      nil)
  )
