/****************************************************************
**
** Attal : Lords of Doom
**
** attalSound.h
** Manage sound and music (or not) for attal client
**
** Version : $Id: attalSound.h,v 1.5 2004/08/07 19:34:45 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 22/09/2003
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#ifndef ATTALSOUND_H
#define ATTALSOUND_H

#ifdef WITH_SOUND
// generic include files
// include files for QT
#include <qstring.h>
// application specific include files


#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>

/*              ------------------------------
 *                         AttalSound
 *              ------------------------------ */

class AttalSound
{

public:
	enum SoundType {
		SND_HIT,
		SND_ARROW,
		SND_GOOD,
		SND_WIN
	};
	
	/** Constructor */
	AttalSound();

	/** Destructor */
	~AttalSound();

	void init();

	void clear();

	void enableSound();

	void disableSound();

	bool isSoundEnabled();
	
	void playSound( SoundType snd );

	void playMusicMap();

	void playMusicBase( unsigned int race );

	void playMusicFight();

protected:
	QString computeSoundFile( SoundType snd );
	
	Mix_Music * _music;
	Mix_Chunk * _sound;
	int _soundId;
	bool _enabled;

};

#else // No sound!!

class AttalSound
{

public:
	enum SoundType {
		SND_HIT,
		SND_ARROW,
		SND_GOOD,
		SND_WIN
	};
	
	/** Constructor */
	AttalSound() {}

	~AttalSound() {}

	void init() {}

	void clear() {}

	void enableSound() {}

	void disableSound() {}

	bool isSoundEnabled() { return false; }
	
	void playSound( SoundType ) {}

	void playMusicMap() {}

	void playMusicBase( unsigned int ) {}

	void playMusicFight() {}
};

#endif

#endif // ATTALSOUND_H
