/****************************************************************
**
** Attal : Lords of Doom
**
** calendar.cpp
** class for managing days, weeks, months
**
** Version : $Id: calendar.cpp,v 1.6 2004/09/17 18:44:14 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 02/01/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "calendar.h"

#include "libCommon/dataTheme.h"


extern DataTheme DataTheme;
 
// generic include files
// include files for QT
// application specific include files

#define FIRST_LEVEL 7
#define SECOND_LEVEL 4
#define THIRD_LEVEL 12
#define MAX_NAME 30
#define MAX_LEVEL 3

/** add comments here */
Calendar::Calendar()
	:_day( 0 ),
	 _week( 1 ),
	 _month( 1 ),
	 _year( 1044 )
{

}

void Calendar::reinit()
{
	_day = 0;
	_daym = 0;
	_month = 1;
	_week = 1;
	_year = 1044;
}

void Calendar::newDay()
{
	_day++;
	_daym++;
	if( _day > FIRST_LEVEL ) {
		_day = 1;
		_week++;
	}
	if( _week > SECOND_LEVEL ) {
		_week = 1;
		_month++;
		_daym = 1;
	}
	/*if( _daym > SECOND_LEVEL ) {
		_daym = 1;
		_month++;
	}*/
	if( _month > THIRD_LEVEL ) {
		_month = 1;
		_year++;
	}
	
	emit sig_changed();
}

QString Calendar::getDate() 
{
	CalendarModel * tmpCal = DataTheme.general.getCalendar();
	Q_CHECK_PTR(tmpCal);
	//return "";
	return tmpCal->getLevelName(0,(_day-1)) +	QString( ", %1 " ).arg( _daym ) + tmpCal->getLevelName(2,(_month-1)) + QString( ", %1 " ).arg( _year );
}

//
// ----- CalendarModel -----
//

CalendarModel::CalendarModel()
{
	_name = 0;
	_level[0] = 7;
	_level[1] = 4;
	_level[2] = 12;
	_name = new QPtrVector<QString>(MAX_NAME * MAX_LEVEL); 
	_name->setAutoDelete(true);
}	

CalendarModel::~CalendarModel()
{
	if (_name)
	{
		_name->clear();
		delete _name;
		_name = 0;
	}
}

QString CalendarModel::getLevelName (uint level, uint num )
{
	if( level < MAX_LEVEL){
		if( num < _level[level] ) {
			if( _name->at( level * MAX_NAME + num ) ) {
				//logDD(" level %d, num %d",level,num);
				//logDD("name %s",_name->at(level * 30 +num)->latin1());
				return *_name->at(level * MAX_NAME +num);
			}
		}
	}
	return "";

}

void CalendarModel::setLevelName (uint level, uint num, const QString & name )
{
	//logDD("level %d, num %d",level,num);
	//logDD("name %s",_name->at(level * 30 +num)->latin1());
	if( level < MAX_LEVEL && name) {
		if( num < _level[level] ) {
			_name->insert(level * MAX_NAME + num, new QString(name));
		}
	}

}

uint CalendarModel::getLevelValue( uint level) 
{
	if( level < MAX_LEVEL)
		return _level[level];
	return 0;
}

void CalendarModel::setLevelValue( uint level, uint value ) 
{
	if( level < MAX_LEVEL)
		_level[level] = value; 
}

