/*
 * ui.hh - header for ui.cc for Bombermaze
 * written by Sydney Tang <stang@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more details see the file COPYING.
 */

#ifndef _BOMBER_UI_H_
#define _BOMBER_UI_H_

#include <config.h>
#include <stdio.h>

#include "gtk/gtk.h"

typedef GtkWidget   UIWidget;
typedef GdkWindow   UIWindow;
typedef GdkDrawable UIDrawable;
typedef GdkGC       UIGraphicsContext;

struct UIDisplayInterface
{
  UIWindow *window;
  UIGraphicsContext *gc;
};

gboolean realize( GtkWidget *widget, gpointer data );
gboolean expose_event(GtkWidget *widget, GdkEventExpose *event, gpointer data);

void ui_quit_game(void);

void ui_clear_status_message(void);
void ui_clear_score_display(void);
void ui_warning_dialog(GtkWidget *parent, char *message);

bool ui_set_theme(const char *directory);
bool ui_check_for_valid_theme(void);
bool ui_apply_pending_theme_change(void);
void ui_notify_invalid_theme(void);

void ui_notify_invalid_map(void);


class SpriteFrame
{
 public:

  GdkPixmap *pixmap;
  GdkBitmap *mask;

  SpriteFrame();
  ~SpriteFrame();
};

class Sprite
{
 public:

  static const int SPRITE_MASK_ALPHA_THRESHOLD;
  
  SpriteFrame *frame;

  Sprite();
  ~Sprite();

  static void set_source_directory(char *directory);
  static void set_source_window(GdkWindow *win);
  static void set_standard_dimensions(unsigned w, unsigned h);
  static void get_standard_dimensions(unsigned &w, unsigned &h);

  void deallocate_frames(void);

  bool load_sprite_from_file( char *file,
                              unsigned cols,
                              unsigned rows,
                              unsigned n_frames );

  bool load_sprite_from_file_and_validate( char *file,
                                           unsigned cols,
                                           unsigned rows,
                                           unsigned n_frames );

  void draw_sprite (unsigned frame_index,
                    GdkDrawable *drawable,
                    GdkGC *gc,
                    int x,
                    int y,
                    int x_step,
                    int y_step);

  void draw_bottom_of_sprite (unsigned frame_index,
                              GdkDrawable *drawable,
                              GdkGC *gc,
                              int x_step,
                              int y_step);

  void draw_top_of_sprite (unsigned frame_index,
                           GdkDrawable *drawable,
                           GdkGC *gc,
                           int x_step,
                           int y_step);

  unsigned get_number_of_frames(void);
  int get_width(void);
  int get_height(void);
  int get_excess_height(void);
  
 protected:
  static char *Source_Directory;
  static GdkWindow *Source_Window;
  static unsigned Standard_Height;
  static unsigned Standard_Width;
  static unsigned X_Step_Size;
  static unsigned Y_Step_Size;
  
  unsigned frames;
  int width;
  int height;
  int excess_height;  

  bool validate_sprite_dimensions(char *name);
  void determine_excess_height(void);
};

#endif
