﻿#region license
// Copyright (c) 2004, Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

def value(x as long, y as long, z as long):
	return 2**x * 3**y * 5**z

def ugly(max as int):
	uglies = []
	counter = 1L
	dict = {1L : (0L, 0L, 0L)}
	
	while len(uglies) < max:
		uglies.Add(counter)
		x, y, z = dict[counter] as (long)
		
		dict[value(x+1, y, z)] = (x+1, y, z)
		dict[value(x, y+1, z)] = (x, y+1, z)
		dict[value(x, y, z+1)] = (x, y, z+1)
		
		dict.Remove(counter)
		
		keys = array(long, dict.Count)
		dict.Keys.CopyTo(keys, 0)
		System.Array.Sort(keys)
		
		counter = keys[0]
	
	return uglies[-1]
	
iter = 1500
start = date.Now
for i in range(10):
	uvalue = ugly(iter)

stop = date.Now
print("${iter} ugly value = ${uvalue} in ${(stop-start).TotalMilliseconds}ms")

