/*
 * Copyright (C) 2003  Robert Collins  <robertc@squid-cache.org>
 *               2004  Rob Weir <rweir@ertius.org>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * DO NOT ALTER THE NEXT LINE
 * arch-tag: 86ccf9ce-01a4-40bd-a9c0-4e5289ed14eb
 *
 */

#include "ConfigSVNSource.h"
#include <iostream>
#include <stdexcept>
#include <getopt++/GetOption.h>
#include <getopt++/StringOption.h>
#include <getopt++/BoolOption.h>
#include <cassert>
#include <cstdlib>
#include <fstream>
#include "Path.h"


using namespace std;

ConfigSVNSource::ConfigSVNSource() 
{
}

ConfigSVNSource::ConfigSVNSource(string const &aUrl) : theUrl(aUrl)
{
    fake_url = aUrl;
    if ((theUrl.find("svn://") == 0) || (theUrl.find("svn+ssh://") == 0)) {
        real_url = aUrl;
    } else {
        real_url = theUrl.substr(4);
    }

    if (Verbose()) {
      cout << " processed SVN url: " << aUrl << "giving fake_url: " << fake_url << " and real_url: " << real_url << endl;
    }
}

string
ConfigSVNSource::url(bool const &stripScheme) const
{
    return (stripScheme ? fake_url : fake_url.substr(fake_url.find("://") + 2));
}

void
ConfigSVNSource::get
    (string const &where) const throw(exception *)
{
    string command = "cd `dirname " + where + "` && svn co " + real_url + " " + where;

    run (command, "SVN");
}

void
ConfigSVNSource::update (string const &where) const throw(exception *)
{
    string command = "cd " + where + " && svn update";

    run (command, "SVN");
}

int
ConfigSVNSource::changes (string const &where) const throw(exception *)
{
    string command = "cd " + where + " && svn diff | grep . > /dev/null || return 1 && return 0";

    return run_query (command, "SVN");
}

int
ConfigSVNSource::missing (string const &where) const throw(exception *)
{
    string command = "cd " + where + "&& svn status -u | grep ""\\*"" > /dev/null && return 1 || return 0";

    return run_query(command, "SVN");
}

string
ConfigSVNSource::getOneLineFile(string const & where) const
{
    ifstream buffer(where.c_str());
    string result;
    if (buffer.is_open())
	buffer >> result;
    return result;
}

string 
ConfigSVNSource::getRoot(string const &where) const
{
    return getOneLineFile(where + "/CVS/Root");
}

string 
ConfigSVNSource::getRepository(string const &where) const
{
    return getOneLineFile(where + "/CVS/Repository");
}

string
ConfigSVNSource::treeVersion(string const &where) const
{
}

void
ConfigSVNSource::ignore (ConfigSource const *, string const &where) const throw (std::exception *)
{
}

/* Repository (CVS/Root) + module + tag must remain the same */
ConfigSVNSource*
ConfigSVNSource::Create(Path const &location, ConfigSource const *mayBeParent) throw (std::exception *)
{
    ConfigSVNSource const *parent = dynamic_cast<ConfigSVNSource const *>(mayBeParent);

//     ConfigSVNSource *result = new ConfigSVNSource;
//     string Root = result->getRoot(location.fullName());
//     if (!Root.size()) {
// 	delete result;
// 	return NULL;
//     }
//     string Repository = result->getRepository(location.fullName());
//     if (!Repository.size()) {
// 	delete result;
// 	return NULL;
//     }
//     /* No parent, valid CVS dir */
//     if (!parent) {
// 	ConfigSVNSource *realResult = new ConfigSVNSource(result->treeVersion(location.fullName()));
// 	delete result;
// 	return realResult;
//     }
//     string canonical = Root + "/" + Repository;
//     canonical = schemeFromRepository(canonical);
//     /* check for a change in parent */
//     if ((canonical.find(urlScheme(parent->scheme) + parent->repository + "/" + parent->module) != 0)  ||
// 	/* XXX: fixme tags */
// 	(parent->tag != result->tag))
//       {
// 	/* new source */
// 	ConfigSVNSource *realResult = new ConfigSVNSource(result->treeVersion(location.fullName()));
// 	delete result;
// 	return realResult;
//       }
//     delete result;
    return const_cast<ConfigSVNSource *>(parent);
}
