/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.datamodel.SequenceI;
import jalview.schemes.Consensus;
import jalview.schemes.ConsensusColour;
import jalview.schemes.ResidueColourScheme;
import jalview.schemes.ResidueProperties;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;

public class ClustalxColourScheme
extends ResidueColourScheme {
    public static Hashtable colhash = new Hashtable();
    Hashtable[] cons;
    int[][] cons2;
    ConsensusColour[] colours;
    ConsensusColour[] ResidueColour;
    int size;
    Consensus[] conses = new Consensus[32];
    Vector colourTable = new Vector();
    private boolean includeGaps = true;

    public ClustalxColourScheme(Vector seqs, int maxWidth) {
        colhash.put("RED", new Color(0.9f, 0.2f, 0.1f));
        colhash.put("BLUE", new Color(0.5f, 0.7f, 0.9f));
        colhash.put("GREEN", new Color(0.1f, 0.8f, 0.1f));
        colhash.put("ORANGE", new Color(0.9f, 0.6f, 0.3f));
        colhash.put("CYAN", new Color(0.1f, 0.7f, 0.7f));
        colhash.put("PINK", new Color(0.9f, 0.5f, 0.5f));
        colhash.put("MAGENTA", new Color(0.8f, 0.3f, 0.8f));
        colhash.put("YELLOW", new Color(0.8f, 0.8f, 0.0f));
        this.resetClustalX(seqs, maxWidth);
    }

    public void resetClustalX(Vector seqs, int maxWidth) {
        int i;
        this.cons2 = new int[maxWidth][24];
        this.includeGaps = this.isIncludeGaps();
        int start = 0;
        for (int j = 0; j < 24; ++j) {
            for (i = 0; i < maxWidth; ++i) {
                this.cons2[i][j] = 0;
            }
        }
        for (int j = 0; j < seqs.size(); ++j) {
            char[] seq = ((SequenceI)seqs.elementAt(j)).getSequence();
            int end_j = seq.length - 1;
            for (i = start; i <= end_j; ++i) {
                int res = seq.length - 1 < i ? 23 : ResidueProperties.aaIndex[seq[i]];
                int[] nArray = this.cons2[i];
                int n = res;
                nArray[n] = nArray[n] + 1;
            }
        }
        this.size = seqs.size();
        this.makeColours();
    }

    public void makeColours() {
        this.conses[0] = new Consensus("WLVIMAFCYHP", 60.0);
        this.conses[1] = new Consensus("WLVIMAFCYHP", 80.0);
        this.conses[2] = new Consensus("ED", 50.0);
        this.conses[3] = new Consensus("KR", 60.0);
        this.conses[4] = new Consensus("G", 50.0);
        this.conses[5] = new Consensus("N", 50.0);
        this.conses[6] = new Consensus("QE", 50.0);
        this.conses[7] = new Consensus("P", 50.0);
        this.conses[8] = new Consensus("TS", 50.0);
        this.conses[26] = new Consensus("A", 85.0);
        this.conses[27] = new Consensus("C", 85.0);
        this.conses[10] = new Consensus("E", 85.0);
        this.conses[11] = new Consensus("F", 85.0);
        this.conses[12] = new Consensus("G", 85.0);
        this.conses[13] = new Consensus("H", 85.0);
        this.conses[14] = new Consensus("I", 85.0);
        this.conses[15] = new Consensus("L", 85.0);
        this.conses[16] = new Consensus("M", 85.0);
        this.conses[17] = new Consensus("N", 85.0);
        this.conses[18] = new Consensus("P", 85.0);
        this.conses[19] = new Consensus("Q", 85.0);
        this.conses[20] = new Consensus("R", 85.0);
        this.conses[21] = new Consensus("S", 85.0);
        this.conses[22] = new Consensus("T", 85.0);
        this.conses[23] = new Consensus("V", 85.0);
        this.conses[24] = new Consensus("W", 85.0);
        this.conses[25] = new Consensus("Y", 85.0);
        this.conses[28] = new Consensus("K", 85.0);
        this.conses[29] = new Consensus("D", 85.0);
        this.conses[30] = new Consensus("G", 0.0);
        this.conses[31] = new Consensus("P", 0.0);
        this.colours = new ConsensusColour[11];
        Consensus[] tmp8 = new Consensus[]{this.conses[30]};
        this.colours[7] = new ConsensusColour((Color)colhash.get("ORANGE"), tmp8);
        Consensus[] tmp9 = new Consensus[]{this.conses[31]};
        this.colours[8] = new ConsensusColour((Color)colhash.get("YELLOW"), tmp9);
        Consensus[] tmp10 = new Consensus[]{this.conses[27]};
        this.colours[9] = new ConsensusColour((Color)colhash.get("PINK"), tmp8);
        Consensus[] tmp1 = new Consensus[]{this.conses[0], this.conses[1], this.conses[26], this.conses[27], this.conses[11], this.conses[13], this.conses[14], this.conses[15], this.conses[16], this.conses[23], this.conses[24], this.conses[25], this.conses[18], this.conses[19]};
        this.colours[0] = new ConsensusColour((Color)colhash.get("BLUE"), tmp1);
        this.colours[10] = new ConsensusColour((Color)colhash.get("CYAN"), tmp1);
        Consensus[] tmp2 = new Consensus[]{this.conses[8], this.conses[21], this.conses[22], this.conses[0], this.conses[1]};
        this.colours[1] = new ConsensusColour((Color)colhash.get("GREEN"), tmp2);
        Consensus[] tmp3 = new Consensus[]{this.conses[17], this.conses[29], this.conses[5]};
        this.colours[2] = new ConsensusColour((Color)colhash.get("GREEN"), tmp3);
        Consensus[] tmp4 = new Consensus[]{this.conses[6], this.conses[19], this.conses[22], this.conses[3], this.conses[28], this.conses[20]};
        this.colours[3] = new ConsensusColour((Color)colhash.get("GREEN"), tmp4);
        Consensus[] tmp5 = new Consensus[]{this.conses[3], this.conses[28], this.conses[20], this.conses[19]};
        this.colours[4] = new ConsensusColour((Color)colhash.get("RED"), tmp5);
        Consensus[] tmp6 = new Consensus[]{this.conses[3], this.conses[29], this.conses[10], this.conses[6], this.conses[19]};
        this.colours[5] = new ConsensusColour((Color)colhash.get("MAGENTA"), tmp6);
        Consensus[] tmp7 = new Consensus[]{this.conses[3], this.conses[29], this.conses[10], this.conses[17], this.conses[2]};
        this.colours[6] = new ConsensusColour((Color)colhash.get("MAGENTA"), tmp7);
        this.ResidueColour = new ConsensusColour[20];
        this.ResidueColour[0] = this.colours[0];
        this.ResidueColour[1] = this.colours[4];
        this.ResidueColour[2] = this.colours[2];
        this.ResidueColour[3] = this.colours[6];
        this.ResidueColour[4] = this.colours[0];
        this.ResidueColour[5] = this.colours[3];
        this.ResidueColour[6] = this.colours[5];
        this.ResidueColour[7] = this.colours[7];
        this.ResidueColour[8] = this.colours[10];
        this.ResidueColour[9] = this.colours[0];
        this.ResidueColour[10] = this.colours[0];
        this.ResidueColour[11] = this.colours[4];
        this.ResidueColour[12] = this.colours[0];
        this.ResidueColour[13] = this.colours[0];
        this.ResidueColour[14] = this.colours[8];
        this.ResidueColour[15] = this.colours[1];
        this.ResidueColour[16] = this.colours[1];
        this.ResidueColour[17] = this.colours[0];
        this.ResidueColour[18] = this.colours[10];
        this.ResidueColour[19] = this.colours[0];
    }

    public Color findColour(char c) {
        return Color.pink;
    }

    public Color findColour(char c, int j) {
        if (this.cons2.length <= j || this.includeGaps && this.threshold != 0 && !this.aboveThreshold(c, j)) {
            return Color.white;
        }
        int i = ResidueProperties.aaIndex[c];
        Color currentColour = Color.white;
        if (i > 19) {
            return currentColour;
        }
        for (int k = 0; k < this.ResidueColour[i].conses.length; ++k) {
            if (!this.ResidueColour[i].conses[k].isConserved(this.cons2, j, this.size, this.includeGaps)) continue;
            currentColour = this.ResidueColour[i].c;
        }
        if (i == 4 && this.conses[27].isConserved(this.cons2, j, this.size, this.includeGaps)) {
            currentColour = (Color)colhash.get("PINK");
        }
        if (this.conservationColouring) {
            currentColour = this.applyConservation(currentColour, j);
        }
        return currentColour;
    }

    protected boolean isIncludeGaps() {
        return this.includeGaps;
    }

    protected void setIncludeGaps(boolean includeGaps) {
        this.includeGaps = includeGaps;
    }
}

