// $Id: fixed.cc,v 1.25 2002/10/23 06:30:39 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_Fixed : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Fixed();
	void AddChild(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
//	void ConfigureChildren(CxxFile &f,const Widget &w,const std::string &instance) const;
//	virtual void Configure(const Widget &w,CxxFile &f,const std::string &instance) const;
};

static Gtk_Fixed Gtk_Fixed;

const std::string Gtk_Fixed::TypeName(const Widget &w) const
{  return GtkPrefix()+"Fixed";
}

const std::string Gtk_Fixed::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"fixed.h";
}

Gtk_Fixed::Gtk_Fixed()
{  Writer["GtkFixed"]=this;
}

void Gtk_Fixed::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{  int x=0;
   int y=0;
   
   if (Configuration.glade2)
   {  const ChildParamList ch(w.get_Child_params());
      x=ch.getIntProperty("x",0);
      y=ch.getIntProperty("y",0);
   }
   else
   {  x=w.getIntProperty("x",0);
      y=w.getIntProperty("y",0);
   }
   f.Statement() << instance << "put" << '(' 
     << Reference(w) << ", " << x << ", " << y << ')';
}

