// $Id: separatortoolitem.cc,v 1.2 2004/05/12 07:12:57 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "toolitem.hh"

class Gtk_SeparatorToolItem : public Gtk_ToolItem
{public:
	typedef Gtk_ToolItem Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_SeparatorToolItem(bool base_class_init=true);
	virtual bool NeedExplicitCtor(const Widget &w) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
};


static Gtk_SeparatorToolItem Gtk_SeparatorToolItem(false);

const std::string Gtk_SeparatorToolItem::TypeName(const Widget &w) const
{  return GtkPrefix()+"SeparatorToolItem";
}

const std::string Gtk_SeparatorToolItem::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"separatortoolitem.h";
}

Gtk_SeparatorToolItem::Gtk_SeparatorToolItem(bool base_class_init)
{  if (!base_class_init) Writer["GtkSeparatorToolItem"]=this;
}

void Gtk_SeparatorToolItem::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
}

bool Gtk_SeparatorToolItem::NeedExplicitCtor(const Widget &w) const
{  return false; }

