
/* This file is part of GMetaDOM
 * a generic bind package for the Document Object Model API.
 * Copyright (C) 2001-2002 Luca Padovani <luca.padovani@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project home page
 * http://gmetadom.sourceforge.net
 * or send an email to <luca.padovani@cs.unibo.it>
 */

#ifndef __GdomeSmartDOMCharacterData_hh__
#define __GdomeSmartDOMCharacterData_hh__

#include "GdomeSmartDOMNode.hh"

namespace GdomeSmartDOM {

class CharacterData : public Node
{
protected:
  explicit CharacterData(GdomeCharacterData* obj, bool) : Node((GdomeNode*) obj) { }
public:
  explicit CharacterData(GdomeCharacterData* = 0);
    CharacterData(const CharacterData&);
  CharacterData(const Node&);
  ~CharacterData();
CharacterData& operator=(const CharacterData&);
  bool operator==(const CharacterData& obj) const { return gdome_obj == obj.gdome_obj; }
  bool operator!=(const CharacterData& obj) const { return !(*this == obj); }
  
  // Attributes  
  class GdomeString get_data(void) const;
  void set_data(const class GdomeString&) const;
  unsigned long get_length(void) const;
  
  // Methods
  class GdomeString substringData(const unsigned long offset, const unsigned long count) const;
  void appendData(const class GdomeString& arg) const;
  void insertData(const unsigned long offset, const class GdomeString& arg) const;
  void deleteData(const unsigned long offset, const unsigned long count) const;
  void replaceData(const unsigned long offset, const unsigned long count, const class GdomeString& arg) const;
  
  // Friend classes
  friend class Document;
  };

}

#endif // __GdomeSmartDOMCharacterData_hh__

