/*
 * GPG Keys 
 * functions.h
 * (c) 2001 Peter Mathiasson <peter@mathiasson.nu>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation
 */

#ifndef __FUNCTIONS_H__
#define __FUNCTIONS_H__

#include <qstring.h>
#include "config.h"

class QComboBox;
class QPixmap;
class QIconSet;
class QStatusBar;

/* GPG Routines */
const QString getTrust( const QString trust );
const QString getCipher( const QString id );
void runFailed( QStatusBar *statusBar );

/* GFX Routines */
//const QPixmap getPixmap( const char *name );
//const QIconSet getIconSet( const char *name );

/* Settings */
QString readConfigString( const QString key, QString def = QString::null );
int readConfigInt( const QString key, int def = 0 );
QFont readConfigFont( const QString key, const QString family, const int pointSize,
                      const int weight, const int italic );
void writeConfigString( const QString key, const QString value );
void writeConfigInt( const QString key, int value );
void writeConfigFont( const QString key, QFont font );

/* QT Addons */
void setComboBoxText( QComboBox *box, const QString text );

/* Utf8 Convertion */
QString fromUtf8( const QString string );


#endif // __FUNCTIONS_H__
