/***************************************************************************
                          pg_query.h  -  description
                             -------------------
    begin                : Mon May 22 2000
    copyright            : (C) 2000 by Thierry Florac
    email                : tflorac@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PG_QUERY_H
#define PG_QUERY_H

#include "pg_connection.h"

typedef struct _pgQuery pgQuery;


/** pgQuery creation function */
pgQuery* pg_query_new (pgConnection *connection);
pgQuery* pg_query_new_with_sql (pgConnection *connection, gchar *sql);

/** Updating pgQuery SQL code */
gboolean pg_query_set_sql (pgQuery *query, gchar *sql);

/** pgQuery execution function */
gboolean pg_query_execute (pgQuery *query);

/** pgQuery opening function */
gint     pg_query_open (pgQuery *query);

gboolean pg_query_close (pgQuery *query);
gboolean pg_query_is_active (pgQuery *query);

/** pgQuery functions to retrieve query results */
gint   pg_query_get_recordcount (pgQuery *query);
gint   pg_query_get_fieldcount (pgQuery *query);
gchar* pg_query_get_fieldname (pgQuery *query, int index);
gint   pg_query_get_fieldindex (pgQuery *query, gchar *fieldname);
gchar* pg_query_get_fieldvalue (pgQuery *query, int index);
gchar* pg_query_get_fieldvalue_byname (pgQuery *query, gchar *fieldname);

/** PGQuery cursor movements */
gboolean pg_query_jumpto (pgQuery *query, int index);
gboolean pg_query_move_first (pgQuery *query);
gboolean pg_query_move_prev (pgQuery *query);
gboolean pg_query_move_next (pgQuery *query);
gboolean pg_query_move_last (pgQuery *query);

gboolean pg_query_at_BOF (pgQuery *query);
gboolean pg_query_at_EOF (pgQuery *query);

void pg_query_show_error (pgQuery *query, gchar *start, gchar *end);

/** Function to free resources affected to pgQuery */
void pg_query_free (pgQuery *query);

#endif
