/***************************************************************************
 *
 *  $Id: kzenitem.cpp,v 1.11 2005/06/01 08:04:20 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <kiconloader.h>

#include "kzenitem.h"

KZenItem::KZenItem(QListView * parent, ItemType type)
  :KListViewItem(parent)
{
  fItemType = type; 

  fSortColumn = KZen::FieldArtist;
  fSortOrder = Qt::Ascending;
}

KZenItem::KZenItem(QListViewItem * parent, ItemType type)
  :KListViewItem(parent)
{
  fItemType = type; 

  fSortColumn = KZen::FieldArtist;
  fSortOrder = Qt::Ascending;
}

KZenItem::~KZenItem()
{
  
}

void KZenItem::triggerUpdate()
{
  listView()->triggerUpdate();
}

int KZenItem::compare(QListViewItem * i, int col, bool ascending) const
{
  KZenItem * item = (KZenItem*) i;

  if (item->getItemType()==ItemTypeArtist && getItemType()==ItemTypeAlbumTL) {
    return 1;
  } else 
  if (item->getItemType()==ItemTypeAlbumTL && getItemType()==ItemTypeArtist) {
    return -1;
  } else

  if (item->getItemType()==ItemTypeArtist && getItemType()==ItemTypeGenre) {
    return 1;
  } else 
  if (item->getItemType()==ItemTypeGenre && getItemType()==ItemTypeArtist) {
    return -1;
  } else

  if (item->getItemType()==ItemTypeAlbumTL && getItemType()==ItemTypeGenre) {
    return 1;
  } else 
  if (item->getItemType()==ItemTypeGenre && getItemType()==ItemTypeAlbumTL) {
    return -1;
  } else
  
  if (item->getItemType()==ItemTypeArtist && getItemType()==ItemTypePlayList) {
    return 1;
  } else 
  if (item->getItemType()==ItemTypePlayList && getItemType()==ItemTypeArtist) {
    return -1;
  } else
  
  if (item->getItemType()==ItemTypeAlbumTL && getItemType()==ItemTypePlayList) {
    return 1;
  } else 
  if (item->getItemType()==ItemTypePlayList && getItemType()==ItemTypeAlbumTL) {
    return -1;
  } else
  
  if (item->getItemType()==ItemTypeGenre && getItemType()==ItemTypePlayList) {
    return 1;
  } else 
  if (item->getItemType()==ItemTypePlayList && getItemType()==ItemTypeGenre) {
    return -1;
  } else

  if (item->getItemType()==ItemTypeArtist && getItemType()==ItemTypeSmartPlayList) {
    return 1;
  } else 
  if (item->getItemType()==ItemTypeSmartPlayList && getItemType()==ItemTypeArtist) {
    return -1;
  } else 

  if (item->getItemType()==ItemTypeAlbumTL && getItemType()==ItemTypeSmartPlayList) {
    return 1;
  } else 
  if (item->getItemType()==ItemTypeSmartPlayList && getItemType()==ItemTypeAlbumTL) {
    return -1;
  } else 

  if (item->getItemType()==ItemTypeGenre && getItemType()==ItemTypeSmartPlayList) {
    return 1;
  } else 
  if (item->getItemType()==ItemTypeSmartPlayList && getItemType()==ItemTypeGenre) {
    return -1;
  } else 

  if (item->getItemType()==ItemTypeSmartPlayList && getItemType()==ItemTypePlayList) {
    return 1;
  } else
  if (item->getItemType()==ItemTypePlayList && getItemType()==ItemTypeSmartPlayList) {
    return -1;
  } else {
    return QListViewItem::compare(i,col,ascending);
  }
}
