/***************************************************************************
 *
 *  $Id: kzensearch.cpp,v 1.3 2005/05/31 06:54:03 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <iostream>

#include "kzentrack.h"
#include "kzensearchcondition.h"

#include "kzensearch.h"

KZenSearch::KZenSearch()
{
  fSearchMode = ModeAND;

  fConditions.setAutoDelete(true);
}

KZenSearch::KZenSearch(KZenSearch * search)
{
  fSearchMode = search->getSearchMode();

  fConditions.setAutoDelete(true);

  KZenSearchCondition * con;
  for (uint i=0;i<search->getConditions().count();i++) {
    con = search->getConditions().at(i);
    fConditions.append(new KZenSearchCondition(con));
  }
}

KZenSearch::~KZenSearch()
{

}

bool KZenSearch::checkTrack(KZenTrack * track)
{
  if (fConditions.count()==0) return false;
  
  bool ret;
  if (fSearchMode==ModeAND) {
    ret = true;
  } else if (fSearchMode==ModeOR) {
    ret = false;
  } else {
    return false;
  }

  KZenSearchCondition * con;
  for (uint i=0;i<fConditions.count();i++) {
    con = fConditions.at(i);
  
    if (fSearchMode==ModeAND) {
      ret &= con->checkTrack(track);
    } else if (fSearchMode==ModeOR) {
      ret |= con->checkTrack(track);
    }    
  }
  
  return ret;
}

void KZenSearch::assign(KZenSearch * search)
{
  fSearchMode = search->getSearchMode();

  fConditions.clear();

  KZenSearchCondition * con;
  for (uint i=0;i<search->getConditions().count();i++) {
    con = search->getConditions().at(i);
    fConditions.append(new KZenSearchCondition(con));
  }
}

QDataStream & operator<<(QDataStream & s, 
			 KZenSearch & search)
{
  s << (int)search.getSearchMode();
  s << (int)search.getConditions().count();

  KZenSearchCondition * con = search.getConditions().first();
  while (con) {
    s << *con;
    con = search.getConditions().next();
  }

  return s;
}

QDataStream & operator>>(QDataStream & s, 
			 KZenSearch & search)
{
  int mode;
  s >> mode;
  search.setSearchMode((KZenSearch::SearchMode)mode);

  int count;
  s >> count;
  
  search.getConditions().clear();

  KZenSearchCondition * con;
  for (int i=0;i<count;i++) {
    con = new KZenSearchCondition();
    s >> *con;
    search.getConditions().append(con);
  }

  return s;
}
