/***************************************************************************
 *
 *  $Id: kzensplashscreen.cpp,v 1.3 2005/05/31 06:54:03 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <iostream>

#include <qpixmap.h>
#include <qapplication.h>
#include <qtimer.h>

#include "kzensplashscreen.h"

KZenSplashScreen::KZenSplashScreen(const QPixmap & pixmap)
  :QSplashScreen(pixmap)
{
  fMayClose = true;
}

KZenSplashScreen::~KZenSplashScreen()
{
  
}

void KZenSplashScreen::message(const QString & m)
{
  QSplashScreen::message(m);
  qApp->processEvents();
}

void KZenSplashScreen::timeout()
{
  fMayClose = true;
}

void KZenSplashScreen::wait()
{
  fMayClose = false;
  QTimer::singleShot(1500,this,SLOT(timeout()));
}

#include "kzensplashscreen.moc"
